<?php
session_start();
require_once 'config/config.php';
require_once 'includes/functions.php';

// Session'dan başarılı işlem bilgilerini al
if (!isset($_SESSION['quote_success'])) {
    header('Location: index.php');
    exit;
}

$quote_data = $_SESSION['quote_success'];
unset($_SESSION['quote_success']); // Tek kullanımlık

// Hizmet türü çevirisi
$service_types = [
    'periyodik_bakim' => 'Periyodik Bakım',
    'motor_onarim' => 'Motor Onarımı',
    'kaporta_boya' => 'Kaporta & Boya',
    'genel_onarim' => 'Genel Onarım'
];
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Başvurunuz Alındı - Araç Bakım Servisi</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        :root {
            --primary-blue: #2563eb;
            --secondary-blue: #3b82f6;
            --light-blue: #dbeafe;
            --dark-blue: #1e40af;
            --pure-white: #ffffff;
            --light-gray: #f8fafc;
            --medium-gray: #64748b;
            --dark-gray: #334155;
            --success-green: #10b981;
            --light-green: #d1fae5;
            --gradient-primary: linear-gradient(135deg, #2563eb 0%, #3b82f6 100%);
            --gradient-light: linear-gradient(135deg, #f8fafc 0%, #e2e8f0 100%);
            --gradient-success: linear-gradient(135deg, #10b981 0%, #059669 100%);
            --shadow-sm: 0 1px 2px 0 rgb(0 0 0 / 0.05);
            --shadow-md: 0 4px 6px -1px rgb(0 0 0 / 0.1), 0 2px 4px -2px rgb(0 0 0 / 0.1);
            --shadow-lg: 0 10px 15px -3px rgb(0 0 0 / 0.1), 0 4px 6px -4px rgb(0 0 0 / 0.1);
            --shadow-xl: 0 20px 25px -5px rgb(0 0 0 / 0.1), 0 8px 10px -6px rgb(0 0 0 / 0.1);
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Inter', sans-serif;
            line-height: 1.6;
            color: var(--dark-gray);
            background: var(--gradient-light);
            min-height: 100vh;
        }

        /* Modern Navigation */
        .modern-navbar {
            background: var(--pure-white);
            box-shadow: var(--shadow-md);
            position: sticky;
            top: 0;
            z-index: 1000;
            backdrop-filter: blur(10px);
        }

        .navbar-brand {
            font-family: 'Poppins', sans-serif;
            font-weight: 700;
            font-size: 1.5rem;
            color: var(--primary-blue) !important;
            text-decoration: none;
        }

        .navbar-nav .nav-link {
            font-weight: 500;
            color: var(--dark-gray) !important;
            transition: color 0.3s ease;
            padding: 0.75rem 1rem !important;
        }

        .navbar-nav .nav-link:hover {
            color: var(--primary-blue) !important;
        }

        /* Success Container */
        .success-container {
            min-height: calc(100vh - 80px);
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 2rem 0;
        }

        .success-card {
            background: var(--pure-white);
            border-radius: 24px;
            box-shadow: var(--shadow-xl);
            overflow: hidden;
            max-width: 800px;
            width: 100%;
            margin: 0 1rem;
            border: 1px solid rgba(37, 99, 235, 0.1);
        }

        .success-header {
            background: var(--gradient-success);
            color: white;
            padding: 3rem 2rem 2rem;
            text-align: center;
            position: relative;
        }

        .success-header::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100"><defs><pattern id="dots" width="10" height="10" patternUnits="userSpaceOnUse"><circle cx="5" cy="5" r="1" fill="%23ffffff" opacity="0.1"/></pattern></defs><rect width="100" height="100" fill="url(%23dots)"/></svg>');
        }

        .success-icon {
            width: 100px;
            height: 100px;
            background: rgba(255, 255, 255, 0.2);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 1.5rem;
            font-size: 3rem;
            position: relative;
            z-index: 2;
            animation: successPulse 2s ease-in-out infinite;
        }

        @keyframes successPulse {
            0%, 100% { transform: scale(1); }
            50% { transform: scale(1.05); }
        }

        .success-title {
            font-family: 'Poppins', sans-serif;
            font-size: 2rem;
            font-weight: 700;
            margin-bottom: 0.5rem;
            position: relative;
            z-index: 2;
        }

        .success-subtitle {
            font-size: 1.125rem;
            opacity: 0.9;
            position: relative;
            z-index: 2;
        }

        .success-body {
            padding: 3rem 2rem;
        }

        .quote-id-badge {
            background: var(--light-blue);
            color: var(--dark-blue);
            padding: 1rem 2rem;
            border-radius: 16px;
            font-size: 1.25rem;
            font-weight: 700;
            text-align: center;
            margin-bottom: 2rem;
            border: 2px solid rgba(37, 99, 235, 0.2);
        }

        .info-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 1.5rem;
            margin-bottom: 2rem;
        }

        .info-card {
            background: var(--light-gray);
            border-radius: 16px;
            padding: 1.5rem;
            border: 1px solid rgba(100, 116, 139, 0.1);
        }

        .info-card h6 {
            color: var(--primary-blue);
            font-weight: 600;
            margin-bottom: 1rem;
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        .info-item {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 0.5rem 0;
            border-bottom: 1px solid rgba(100, 116, 139, 0.1);
        }

        .info-item:last-child {
            border-bottom: none;
        }

        .info-label {
            color: var(--medium-gray);
            font-weight: 500;
        }

        .info-value {
            color: var(--dark-gray);
            font-weight: 600;
        }

        .process-timeline {
            background: var(--light-green);
            border-radius: 16px;
            padding: 2rem;
            margin-bottom: 2rem;
            border: 2px solid rgba(16, 185, 129, 0.2);
        }

        .timeline-title {
            color: #065f46;
            font-weight: 700;
            margin-bottom: 1.5rem;
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        .timeline-steps {
            list-style: none;
            padding: 0;
            margin: 0;
        }

        .timeline-step {
            display: flex;
            align-items: center;
            gap: 1rem;
            padding: 0.75rem 0;
            color: #047857;
            font-weight: 500;
        }

        .step-icon {
            width: 24px;
            height: 24px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 0.875rem;
            flex-shrink: 0;
        }

        .step-completed {
            background: #10b981;
            color: white;
        }

        .step-current {
            background: #fbbf24;
            color: white;
            animation: pulse 2s ease-in-out infinite;
        }

        .step-pending {
            background: #e5e7eb;
            color: #6b7280;
        }

        .contact-info {
            background: var(--light-blue);
            border-radius: 16px;
            padding: 2rem;
            margin-bottom: 2rem;
            border: 2px solid rgba(37, 99, 235, 0.2);
        }

        .contact-title {
            color: var(--dark-blue);
            font-weight: 700;
            margin-bottom: 1rem;
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        .contact-item {
            display: flex;
            align-items: center;
            gap: 0.75rem;
            margin-bottom: 0.75rem;
            color: var(--dark-gray);
        }

        .contact-item:last-child {
            margin-bottom: 0;
        }

        .contact-link {
            color: var(--primary-blue);
            text-decoration: none;
            font-weight: 500;
            transition: color 0.3s ease;
        }

        .contact-link:hover {
            color: var(--dark-blue);
            text-decoration: underline;
        }

        .action-buttons {
            display: flex;
            gap: 1rem;
            justify-content: center;
            flex-wrap: wrap;
        }

        .modern-btn {
            padding: 1rem 2rem;
            border-radius: 12px;
            font-weight: 600;
            text-decoration: none;
            transition: all 0.3s ease;
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
            border: none;
            cursor: pointer;
            font-size: 1rem;
        }

        .btn-primary {
            background: var(--gradient-primary);
            color: white;
            box-shadow: var(--shadow-md);
        }

        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: var(--shadow-lg);
            color: white;
        }

        .btn-outline {
            background: transparent;
            color: var(--primary-blue);
            border: 2px solid var(--primary-blue);
        }

        .btn-outline:hover {
            background: var(--primary-blue);
            color: white;
            transform: translateY(-2px);
        }

        /* Loading Animation */
        .loading-dots {
            display: inline-flex;
            gap: 0.25rem;
        }

        .loading-dot {
            width: 6px;
            height: 6px;
            border-radius: 50%;
            background: currentColor;
            animation: loadingDot 1.4s ease-in-out infinite both;
        }

        .loading-dot:nth-child(1) { animation-delay: -0.32s; }
        .loading-dot:nth-child(2) { animation-delay: -0.16s; }

        @keyframes loadingDot {
            0%, 80%, 100% { transform: scale(0); }
            40% { transform: scale(1); }
        }

        @keyframes pulse {
            0%, 100% { opacity: 1; }
            50% { opacity: 0.7; }
        }

        /* Responsive Design */
        @media (max-width: 768px) {
            .success-header {
                padding: 2rem 1.5rem 1.5rem;
            }

            .success-body {
                padding: 2rem 1.5rem;
            }

            .success-title {
                font-size: 1.75rem;
            }

            .info-grid {
                grid-template-columns: 1fr;
            }

            .action-buttons {
                flex-direction: column;
            }

            .modern-btn {
                justify-content: center;
            }
        }

        /* Animations */
        @keyframes fadeInUp {
            from {
                opacity: 0;
                transform: translateY(30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .success-card {
            animation: fadeInUp 0.6s ease-out;
        }
    </style>
</head>
<body>
    <!-- Modern Navigation -->
    <nav class="navbar navbar-expand-lg modern-navbar">
        <div class="container">
            <a class="navbar-brand" href="index.php">
                <i class="fas fa-car me-2"></i>Araç Bakım
            </a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ms-auto">
                    <li class="nav-item">
                        <a class="nav-link" href="index.php">Ana Sayfa</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="about.php">Hakkımızda</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="contact.php">İletişim</a>
                    </li>
                </ul>
            </div>
        </div>
    </nav>

    <!-- Success Content -->
    <div class="success-container">
        <div class="success-card">
            <div class="success-header">
                <div class="success-icon">
                    <i class="fas fa-check"></i>
                </div>
                <h1 class="success-title">Başvurunuz Alındı!</h1>
                <p class="success-subtitle">Teklif başvurunuz başarıyla kaydedilmiştir</p>
            </div>

            <div class="success-body">
                <div class="quote-id-badge">
                    <i class="fas fa-hashtag me-2"></i>
                    Başvuru Numaranız: <span class="text-primary"><?= $quote_data['quote_request_id'] ?></span>
                </div>

                <div class="info-grid">
                    <div class="info-card">
                        <h6><i class="fas fa-user"></i>Müşteri Bilgileri</h6>
                        <div class="info-item">
                            <span class="info-label">Ad Soyad:</span>
                            <span class="info-value"><?= h($quote_data['customer']['first_name'] . ' ' . $quote_data['customer']['last_name']) ?></span>
                        </div>
                        <div class="info-item">
                            <span class="info-label">Telefon:</span>
                            <span class="info-value"><?= h($quote_data['customer']['phone']) ?></span>
                        </div>
                        <?php if (!empty($quote_data['customer']['email'])): ?>
                        <div class="info-item">
                            <span class="info-label">E-posta:</span>
                            <span class="info-value"><?= h($quote_data['customer']['email']) ?></span>
                        </div>
                        <?php endif; ?>
                    </div>

                    <div class="info-card">
                        <h6><i class="fas fa-car"></i>Araç Bilgileri</h6>
                        <div class="info-item">
                            <span class="info-label">Marka/Model:</span>
                            <span class="info-value"><?= h($quote_data['vehicle']['brand'] . ' ' . $quote_data['vehicle']['model']) ?></span>
                        </div>
                        <div class="info-item">
                            <span class="info-label">Model Yılı:</span>
                            <span class="info-value"><?= h($quote_data['vehicle']['year']) ?></span>
                        </div>
                        <?php if (!empty($quote_data['vehicle']['plate'])): ?>
                        <div class="info-item">
                            <span class="info-label">Plaka:</span>
                            <span class="info-value"><?= h($quote_data['vehicle']['plate']) ?></span>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>

                <div class="info-card mb-4">
                    <h6><i class="fas fa-tools"></i>Hizmet Bilgileri</h6>
                    <div class="info-item">
                        <span class="info-label">Hizmet Türü:</span>
                        <span class="info-value"><?= h($service_types[$quote_data['service_type']] ?? $quote_data['service_type']) ?></span>
                    </div>
                    <div class="info-item">
                        <span class="info-label">Başvuru Tarihi:</span>
                        <span class="info-value"><?= date('d.m.Y H:i', strtotime($quote_data['created_at'])) ?></span>
                    </div>
                </div>

                <div class="process-timeline">
                    <h6 class="timeline-title">
                        <i class="fas fa-clock"></i>Süreç Durumu
                    </h6>
                    <ul class="timeline-steps">
                        <li class="timeline-step">
                            <div class="step-icon step-completed">
                                <i class="fas fa-check"></i>
                            </div>
                            <span><strong>Başvuru Alındı</strong> - Tamamlandı</span>
                        </li>
                        <li class="timeline-step">
                            <div class="step-icon step-current">
                                <div class="loading-dots">
                                    <div class="loading-dot"></div>
                                    <div class="loading-dot"></div>
                                    <div class="loading-dot"></div>
                                </div>
                            </div>
                            <span><strong>Teklif Hazırlanıyor</strong> - Devam Ediyor</span>
                        </li>
                        <li class="timeline-step">
                            <div class="step-icon step-pending">
                                <i class="fas fa-paper-plane"></i>
                            </div>
                            <span><strong>Teklif Gönderilecek</strong> - Bekliyor</span>
                        </li>
                        <li class="timeline-step">
                            <div class="step-icon step-pending">
                                <i class="fas fa-wrench"></i>
                            </div>
                            <span><strong>Hizmet Başlayacak</strong> - Bekliyor</span>
                        </li>
                    </ul>
                </div>

                <div class="contact-info">
                    <h6 class="contact-title">
                        <i class="fas fa-headset"></i>İletişim Bilgileri
                    </h6>
                    <p class="mb-3">Sorularınız için bize ulaşabilirsiniz:</p>
                    <div class="contact-item">
                        <i class="fas fa-phone text-primary"></i>
                        <a href="tel:+905321234567" class="contact-link">+90 532 123 45 67</a>
                    </div>
                    <div class="contact-item">
                        <i class="fas fa-envelope text-primary"></i>
                        <a href="mailto:info@aracbakim.com" class="contact-link">info@aracbakim.com</a>
                    </div>
                    <div class="contact-item">
                        <i class="fas fa-clock text-primary"></i>
                        <span>Pazartesi - Cumartesi: 08:00 - 18:00</span>
                    </div>
                </div>

                <div class="action-buttons">
                    <a href="index.php" class="modern-btn btn-primary">
                        <i class="fas fa-home"></i>
                        Ana Sayfaya Dön
                    </a>
                    <a href="contact.php" class="modern-btn btn-outline">
                        <i class="fas fa-phone"></i>
                        İletişime Geç
                    </a>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Smooth scroll to top on page load
        window.addEventListener('load', () => {
            window.scrollTo({ top: 0, behavior: 'smooth' });
        });
    </script>
</body>
</html>