<?php
session_start();
require_once 'config/config.php';
require_once 'includes/functions.php';

$token = $_GET['token'] ?? '';

if (!$token) {
    redirect('index.php');
}

try {
    // Teklifi token ile al
    $stmt = $pdo->prepare("
        SELECT q.*, qr.id as request_id,
               c.first_name, c.last_name, c.phone, c.email,
               v.brand, v.model, v.year
        FROM quotes q
        JOIN quote_requests qr ON q.quote_request_id = qr.id
        JOIN customers c ON qr.customer_id = c.id
        JOIN vehicles v ON qr.vehicle_id = v.id
        WHERE q.quote_token = ? AND q.valid_until > NOW()
    ");
    $stmt->execute([$token]);
    $quote = $stmt->fetch();
    
    if (!$quote) {
        redirect('view_quote.php?token=' . $token);
    }
    
    // Seçili ürünleri session'dan al
    $selected_items = $_SESSION['selected_items'][$token] ?? [];
    
    if (empty($selected_items)) {
        redirect('view_quote.php?token=' . $token);
    }
    
    // Seçili ürünlerin detaylarını al
    $stmt = $pdo->prepare("
        SELECT * FROM quote_items 
        WHERE quote_id = ? AND id IN (" . str_repeat('?,', count($selected_items) - 1) . "?)
    ");
    $stmt->execute(array_merge([$quote['id']], array_keys($selected_items)));
    $items = $stmt->fetchAll();
    
    // Toplam tutarı hesapla
    $total_amount = 0;
    foreach ($items as $item) {
        $quantity = $selected_items[$item['id']] ?? 1;
        $total_amount += $item['line_total'] * $quantity;
    }
    
} catch (Exception $e) {
    error_log("Payment page error: " . $e->getMessage());
    redirect('index.php');
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ödeme - Araç Bakım Servisi</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        :root {
            --primary-blue: #2563eb;
            --secondary-blue: #3b82f6;
            --light-blue: #dbeafe;
            --dark-blue: #1e40af;
            --pure-white: #ffffff;
            --light-gray: #f8fafc;
            --medium-gray: #64748b;
            --dark-gray: #334155;
            --success-green: #10b981;
            --light-green: #d1fae5;
            --gradient-primary: linear-gradient(135deg, #2563eb 0%, #3b82f6 100%);
            --gradient-light: linear-gradient(135deg, #f8fafc 0%, #e2e8f0 100%);
            --shadow-sm: 0 1px 2px 0 rgb(0 0 0 / 0.05);
            --shadow-md: 0 4px 6px -1px rgb(0 0 0 / 0.1), 0 2px 4px -2px rgb(0 0 0 / 0.1);
            --shadow-lg: 0 10px 15px -3px rgb(0 0 0 / 0.1), 0 4px 6px -4px rgb(0 0 0 / 0.1);
            --shadow-xl: 0 20px 25px -5px rgb(0 0 0 / 0.1), 0 8px 10px -6px rgb(0 0 0 / 0.1);
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Inter', sans-serif;
            line-height: 1.6;
            color: var(--dark-gray);
            background: var(--gradient-light);
            min-height: 100vh;
        }

        /* Modern Navigation */
        .modern-navbar {
            background: var(--pure-white);
            box-shadow: var(--shadow-md);
            padding: 1rem 0;
        }

        .navbar-brand {
            font-family: 'Poppins', sans-serif;
            font-weight: 700;
            font-size: 1.5rem;
            color: var(--primary-blue) !important;
            text-decoration: none;
        }

        .nav-link {
            color: var(--medium-gray) !important;
            font-weight: 500;
            text-decoration: none;
            transition: color 0.3s ease;
        }

        .nav-link:hover {
            color: var(--primary-blue) !important;
        }

        /* Payment Container */
        .payment-container {
            max-width: 1200px;
            margin: 2rem auto;
            padding: 0 1rem;
        }

        .payment-card {
            background: var(--pure-white);
            border-radius: 20px;
            box-shadow: var(--shadow-xl);
            overflow: hidden;
            border: 1px solid rgba(37, 99, 235, 0.1);
        }

        .payment-header {
            background: var(--gradient-primary);
            color: white;
            padding: 2rem;
            text-align: center;
        }

        .payment-title {
            font-family: 'Poppins', sans-serif;
            font-size: 2rem;
            font-weight: 700;
            margin-bottom: 0.5rem;
        }

        .payment-subtitle {
            font-size: 1rem;
            opacity: 0.9;
        }

        .payment-body {
            padding: 2rem;
        }

        /* Order Summary */
        .order-summary {
            background: var(--light-gray);
            border-radius: 16px;
            padding: 1.5rem;
            margin-bottom: 2rem;
            border: 1px solid rgba(37, 99, 235, 0.1);
        }

        .summary-title {
            font-family: 'Poppins', sans-serif;
            font-size: 1.25rem;
            font-weight: 600;
            color: var(--dark-blue);
            margin-bottom: 1rem;
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        .summary-item {
            display: flex;
            justify-content: between;
            align-items: center;
            padding: 0.75rem 0;
            border-bottom: 1px solid rgba(37, 99, 235, 0.1);
        }

        .summary-item:last-child {
            border-bottom: none;
            font-weight: 600;
            font-size: 1.125rem;
            color: var(--dark-blue);
        }

        .item-name {
            flex: 1;
            font-weight: 500;
        }

        .item-quantity {
            color: var(--medium-gray);
            margin: 0 1rem;
        }

        .item-price {
            font-weight: 600;
            color: var(--dark-blue);
        }

        /* Payment Methods */
        .payment-methods {
            display: grid;
            gap: 1rem;
            margin-bottom: 2rem;
        }

        .payment-method {
            background: var(--pure-white);
            border: 2px solid #e2e8f0;
            border-radius: 12px;
            padding: 1.5rem;
            cursor: pointer;
            transition: all 0.3s ease;
            display: flex;
            align-items: center;
            gap: 1rem;
        }

        .payment-method:hover {
            border-color: var(--primary-blue);
            transform: translateY(-2px);
            box-shadow: var(--shadow-md);
        }

        .payment-method.selected {
            border-color: var(--primary-blue);
            background: var(--light-blue);
        }

        .payment-method-icon {
            width: 50px;
            height: 50px;
            background: var(--light-blue);
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            color: var(--primary-blue);
            font-size: 1.5rem;
        }

        .payment-method-info h4 {
            font-weight: 600;
            color: var(--dark-blue);
            margin-bottom: 0.25rem;
        }

        .payment-method-info p {
            color: var(--medium-gray);
            font-size: 0.875rem;
            margin: 0;
        }

        /* Form Controls */
        .modern-form-group {
            margin-bottom: 1.5rem;
        }

        .modern-form-label {
            display: block;
            font-weight: 500;
            color: var(--dark-gray);
            margin-bottom: 0.5rem;
        }

        .modern-form-control {
            width: 100%;
            padding: 0.875rem 1rem;
            border: 2px solid #e2e8f0;
            border-radius: 12px;
            font-size: 1rem;
            transition: all 0.3s ease;
            background: var(--pure-white);
        }

        .modern-form-control:focus {
            outline: none;
            border-color: var(--primary-blue);
            box-shadow: 0 0 0 3px rgba(37, 99, 235, 0.1);
        }

        /* Buttons */
        .modern-btn {
            background: var(--gradient-primary);
            color: white;
            border: none;
            padding: 0.875rem 2rem;
            border-radius: 12px;
            font-weight: 600;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
            transition: all 0.3s ease;
            box-shadow: var(--shadow-md);
            cursor: pointer;
            width: 100%;
            justify-content: center;
        }

        .modern-btn:hover {
            transform: translateY(-2px);
            box-shadow: var(--shadow-lg);
            color: white;
        }

        .modern-btn:disabled {
            opacity: 0.6;
            cursor: not-allowed;
            transform: none;
        }

        .modern-btn-outline {
            background: transparent;
            color: var(--primary-blue);
            border: 2px solid var(--primary-blue);
            padding: 0.875rem 2rem;
            border-radius: 12px;
            font-weight: 600;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
            transition: all 0.3s ease;
            cursor: pointer;
            width: 100%;
            justify-content: center;
        }

        .modern-btn-outline:hover {
            background: var(--primary-blue);
            color: white;
            transform: translateY(-2px);
            box-shadow: var(--shadow-md);
        }

        /* Security Info */
        .security-info {
            background: var(--light-green);
            border-radius: 12px;
            padding: 1rem;
            margin-bottom: 2rem;
            border: 1px solid rgba(16, 185, 129, 0.2);
        }

        .security-info h6 {
            color: var(--success-green);
            font-weight: 600;
            margin-bottom: 0.5rem;
        }

        .security-info p {
            color: #047857;
            font-size: 0.875rem;
            margin: 0;
        }

        /* Loading Spinner */
        .loading-spinner {
            display: none;
            width: 20px;
            height: 20px;
            border: 2px solid rgba(255, 255, 255, 0.3);
            border-radius: 50%;
            border-top-color: white;
            animation: spin 1s ease-in-out infinite;
        }

        @keyframes spin {
            to { transform: rotate(360deg); }
        }

        /* Responsive Design */
        @media (max-width: 768px) {
            .payment-container {
                margin: 1rem auto;
                padding: 0 0.5rem;
            }

            .payment-body {
                padding: 1.5rem;
            }

            .payment-method {
                flex-direction: column;
                text-align: center;
            }
        }

        /* Animations */
        @keyframes fadeInUp {
            from {
                opacity: 0;
                transform: translateY(30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .animate-fade-in-up {
            animation: fadeInUp 0.6s ease-out;
        }
    </style>
</head>
<body>
    <!-- Modern Navigation -->
    <nav class="navbar modern-navbar">
        <div class="container">
            <a class="navbar-brand" href="index.php">
                <i class="fas fa-car me-2"></i>
                Araç Bakım Servisi
            </a>
            <div class="navbar-nav">
                <a class="nav-link" href="view_quote.php?token=<?= h($token) ?>">
                    <i class="fas fa-arrow-left me-2"></i>Teklife Dön
                </a>
            </div>
        </div>
    </nav>

    <div class="payment-container">
        <div class="payment-card animate-fade-in-up">
            <div class="payment-header">
                <h1 class="payment-title">
                    <i class="fas fa-credit-card me-2"></i>
                    Güvenli Ödeme
                </h1>
                <p class="payment-subtitle">
                    Seçtiğiniz hizmetler için güvenli ödeme yapın
                </p>
            </div>

            <div class="payment-body">
                <div class="row">
                    <div class="col-lg-8">
                        <!-- Payment Methods -->
                        <h3 style="color: var(--dark-blue); font-weight: 600; margin-bottom: 1.5rem;">
                            <i class="fas fa-wallet me-2"></i>Ödeme Yöntemi Seçin
                        </h3>
                        
                        <div class="payment-methods">
                            <div class="payment-method selected" data-method="credit_card">
                                <div class="payment-method-icon">
                                    <i class="fas fa-credit-card"></i>
                                </div>
                                <div class="payment-method-info">
                                    <h4>Kredi/Banka Kartı</h4>
                                    <p>Visa, Mastercard, American Express</p>
                                </div>
                            </div>
                            
                            <div class="payment-method" data-method="bank_transfer">
                                <div class="payment-method-icon">
                                    <i class="fas fa-university"></i>
                                </div>
                                <div class="payment-method-info">
                                    <h4>Banka Havalesi</h4>
                                    <p>Havale/EFT ile ödeme</p>
                                </div>
                            </div>
                            
                            <div class="payment-method" data-method="installment">
                                <div class="payment-method-icon">
                                    <i class="fas fa-calendar-alt"></i>
                                </div>
                                <div class="payment-method-info">
                                    <h4>Taksitli Ödeme</h4>
                                    <p>12 aya kadar taksit imkanı</p>
                                </div>
                            </div>
                        </div>

                        <!-- Credit Card Form -->
                        <div id="credit_card_form" class="payment-form">
                            <h4 style="color: var(--dark-blue); font-weight: 600; margin-bottom: 1.5rem;">
                                Kart Bilgileri
                            </h4>
                            
                            <form id="paymentForm" action="process_payment.php" method="POST">
                                <input type="hidden" name="token" value="<?= h($token) ?>">
                                <input type="hidden" name="payment_method" value="credit_card">
                                
                                <div class="row">
                                    <div class="col-12">
                                        <div class="modern-form-group">
                                            <label class="modern-form-label" for="card_holder">Kart Sahibi Adı</label>
                                            <input type="text" class="modern-form-control" id="card_holder" name="card_holder" 
                                                   value="<?= h($quote['first_name'] . ' ' . $quote['last_name']) ?>" required>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="row">
                                    <div class="col-md-8">
                                        <div class="modern-form-group">
                                            <label class="modern-form-label" for="card_number">Kart Numarası</label>
                                            <input type="text" class="modern-form-control" id="card_number" name="card_number" 
                                                   placeholder="1234 5678 9012 3456" maxlength="19" required>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="modern-form-group">
                                            <label class="modern-form-label" for="cvv">CVV</label>
                                            <input type="text" class="modern-form-control" id="cvv" name="cvv" 
                                                   placeholder="123" maxlength="4" required>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="modern-form-group">
                                            <label class="modern-form-label" for="expiry_month">Son Kullanma Ayı</label>
                                            <select class="modern-form-control" id="expiry_month" name="expiry_month" required>
                                                <option value="">Ay Seçin</option>
                                                <?php for($i = 1; $i <= 12; $i++): ?>
                                                    <option value="<?= sprintf('%02d', $i) ?>"><?= sprintf('%02d', $i) ?></option>
                                                <?php endfor; ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="modern-form-group">
                                            <label class="modern-form-label" for="expiry_year">Son Kullanma Yılı</label>
                                            <select class="modern-form-control" id="expiry_year" name="expiry_year" required>
                                                <option value="">Yıl Seçin</option>
                                                <?php for($i = date('Y'); $i <= date('Y') + 10; $i++): ?>
                                                    <option value="<?= $i ?>"><?= $i ?></option>
                                                <?php endfor; ?>
                                            </select>
                                        </div>
                                    </div>
                                </div>

                                <!-- Security Info -->
                                <div class="security-info">
                                    <h6><i class="fas fa-shield-alt me-2"></i>Güvenlik</h6>
                                    <p>Ödeme bilgileriniz 256-bit SSL şifreleme ile korunmaktadır. Kart bilgileriniz saklanmaz.</p>
                                </div>

                                <button type="submit" class="modern-btn" id="payButton">
                                    <span class="loading-spinner"></span>
                                    <i class="fas fa-lock me-2"></i>
                                    Güvenli Ödeme Yap (<?= formatMoney($total_amount) ?>)
                                </button>
                            </form>
                        </div>

                        <!-- Bank Transfer Info -->
                        <div id="bank_transfer_form" class="payment-form" style="display: none;">
                            <h4 style="color: var(--dark-blue); font-weight: 600; margin-bottom: 1.5rem;">
                                Banka Hesap Bilgileri
                            </h4>
                            
                            <div style="background: var(--light-blue); border-radius: 12px; padding: 1.5rem; margin-bottom: 1.5rem;">
                                <h6 style="color: var(--dark-blue); font-weight: 600; margin-bottom: 1rem;">
                                    Araç Bakım Servisi - Ziraat Bankası
                                </h6>
                                <p style="margin: 0.5rem 0; color: var(--dark-gray);">
                                    <strong>Hesap No:</strong> 1234567890
                                </p>
                                <p style="margin: 0.5rem 0; color: var(--dark-gray);">
                                    <strong>IBAN:</strong> TR12 0001 0012 3456 7890 1234 56
                                </p>
                                <p style="margin: 0.5rem 0; color: var(--dark-gray);">
                                    <strong>Açıklama:</strong> Teklif No: <?= h($quote['id']) ?>
                                </p>
                            </div>
                            
                            <button type="button" class="modern-btn-outline" onclick="copyBankInfo()">
                                <i class="fas fa-copy me-2"></i>
                                Hesap Bilgilerini Kopyala
                            </button>
                        </div>
                    </div>

                    <div class="col-lg-4">
                        <!-- Order Summary -->
                        <div class="order-summary">
                            <h3 class="summary-title">
                                <i class="fas fa-receipt"></i>
                                Sipariş Özeti
                            </h3>
                            
                            <div style="margin-bottom: 1rem; padding-bottom: 1rem; border-bottom: 1px solid rgba(37, 99, 235, 0.1);">
                                <h6 style="color: var(--dark-blue); font-weight: 600; margin-bottom: 0.5rem;">
                                    <?= h($quote['brand'] . ' ' . $quote['model'] . ' (' . $quote['year'] . ')') ?>
                                </h6>
                                <p style="color: var(--medium-gray); font-size: 0.875rem; margin: 0;">
                                    Müşteri: <?= h($quote['first_name'] . ' ' . $quote['last_name']) ?>
                                </p>
                            </div>
                            
                            <?php foreach ($items as $item): ?>
                                <?php $quantity = $selected_items[$item['id']] ?? 1; ?>
                                <div class="summary-item">
                                    <div class="item-name"><?= h($item['description'] ?? 'Ürün Adı Yok') ?></div>
                                    <div class="item-quantity">x<?= $quantity ?></div>
                                    <div class="item-price"><?= formatMoney($item['line_total'] * $quantity) ?></div>
                                </div>
                            <?php endforeach; ?>
                            
                            <div class="summary-item">
                                <div class="item-name">Toplam Tutar</div>
                                <div></div>
                                <div class="item-price"><?= formatMoney($total_amount) ?></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Payment method selection
        document.querySelectorAll('.payment-method').forEach(method => {
            method.addEventListener('click', function() {
                document.querySelectorAll('.payment-method').forEach(m => m.classList.remove('selected'));
                this.classList.add('selected');
                
                const methodType = this.dataset.method;
                document.querySelectorAll('.payment-form').forEach(form => form.style.display = 'none');
                
                if (methodType === 'credit_card') {
                    document.getElementById('credit_card_form').style.display = 'block';
                } else if (methodType === 'bank_transfer') {
                    document.getElementById('bank_transfer_form').style.display = 'block';
                }
                
                document.querySelector('input[name="payment_method"]').value = methodType;
            });
        });

        // Card number formatting
        document.getElementById('card_number').addEventListener('input', function(e) {
            let value = e.target.value.replace(/\s+/g, '').replace(/[^0-9]/gi, '');
            let formattedValue = value.match(/.{1,4}/g)?.join(' ') || value;
            e.target.value = formattedValue;
        });

        // CVV validation
        document.getElementById('cvv').addEventListener('input', function(e) {
            e.target.value = e.target.value.replace(/[^0-9]/g, '');
        });

        // Form submission
        document.getElementById('paymentForm').addEventListener('submit', function(e) {
            e.preventDefault();
            
            const payButton = document.getElementById('payButton');
            const spinner = payButton.querySelector('.loading-spinner');
            
            payButton.disabled = true;
            spinner.style.display = 'inline-block';
            
            // Simulate payment processing
            setTimeout(() => {
                this.submit();
            }, 2000);
        });

        // Copy bank info
        function copyBankInfo() {
            const bankInfo = `
Araç Bakım Servisi - Ziraat Bankası
Hesap No: 1234567890
IBAN: TR12 0001 0012 3456 7890 1234 56
Açıklama: Teklif No: <?= h($quote['id']) ?>
            `.trim();
            
            navigator.clipboard.writeText(bankInfo).then(() => {
                alert('Hesap bilgileri panoya kopyalandı!');
            });
        }
    </script>
</body>
</html>