<?php
session_start();
require_once 'config/config.php';
require_once 'includes/functions.php';

// Ana sayfa - Sistem tanıtımı ve süreç açıklaması
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Araç Bakım Servisi - Profesyonel Araç Bakım Hizmetleri</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        :root {
            --primary-blue: #2563eb;
            --secondary-blue: #3b82f6;
            --light-blue: #dbeafe;
            --dark-blue: #1e40af;
            --pure-white: #ffffff;
            --light-gray: #f8fafc;
            --medium-gray: #64748b;
            --dark-gray: #334155;
            --gradient-primary: linear-gradient(135deg, #2563eb 0%, #3b82f6 100%);
            --gradient-light: linear-gradient(135deg, #f8fafc 0%, #e2e8f0 100%);
            --shadow-sm: 0 1px 2px 0 rgb(0 0 0 / 0.05);
            --shadow-md: 0 4px 6px -1px rgb(0 0 0 / 0.1), 0 2px 4px -2px rgb(0 0 0 / 0.1);
            --shadow-lg: 0 10px 15px -3px rgb(0 0 0 / 0.1), 0 4px 6px -4px rgb(0 0 0 / 0.1);
            --shadow-xl: 0 20px 25px -5px rgb(0 0 0 / 0.1), 0 8px 10px -6px rgb(0 0 0 / 0.1);
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Inter', sans-serif;
            line-height: 1.6;
            color: var(--dark-gray);
            background: var(--pure-white);
        }

        /* Modern Navigation */
        .modern-navbar {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-bottom: 1px solid rgba(37, 99, 235, 0.1);
            transition: all 0.3s ease;
            padding: 1rem 0;
        }

        .modern-navbar.scrolled {
            background: rgba(255, 255, 255, 0.98);
            box-shadow: var(--shadow-md);
            padding: 0.5rem 0;
        }

        .navbar-brand {
            font-family: 'Poppins', sans-serif;
            font-weight: 700;
            font-size: 1.5rem;
            color: var(--primary-blue) !important;
            text-decoration: none;
        }

        .navbar-nav .nav-link {
            font-weight: 500;
            color: var(--dark-gray) !important;
            margin: 0 0.5rem;
            padding: 0.5rem 1rem !important;
            border-radius: 8px;
            transition: all 0.3s ease;
        }

        .navbar-nav .nav-link:hover {
            color: var(--primary-blue) !important;
            background: var(--light-blue);
        }

        .navbar-nav .nav-link.active {
            color: var(--primary-blue) !important;
            background: var(--light-blue);
        }

        .modern-btn {
            background: var(--gradient-primary);
            color: white;
            border: none;
            padding: 0.75rem 1.5rem;
            border-radius: 12px;
            font-weight: 600;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
            transition: all 0.3s ease;
            box-shadow: var(--shadow-md);
        }

        .modern-btn:hover {
            transform: translateY(-2px);
            box-shadow: var(--shadow-lg);
            color: white;
        }

        .modern-btn-outline {
            background: transparent;
            color: var(--primary-blue);
            border: 2px solid var(--primary-blue);
            padding: 0.75rem 1.5rem;
            border-radius: 12px;
            font-weight: 600;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
            transition: all 0.3s ease;
        }

        .modern-btn-outline:hover {
            background: var(--primary-blue);
            color: white;
            transform: translateY(-2px);
            box-shadow: var(--shadow-md);
        }

        /* Hero Section */
        .hero-section {
            background: linear-gradient(135deg, #f8fafc 0%, #e2e8f0 50%, #dbeafe 100%);
            padding: 120px 0 80px;
            position: relative;
            overflow: hidden;
        }

        .hero-section::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100"><defs><pattern id="grid" width="10" height="10" patternUnits="userSpaceOnUse"><path d="M 10 0 L 0 0 0 10" fill="none" stroke="%232563eb" stroke-width="0.5" opacity="0.1"/></pattern></defs><rect width="100" height="100" fill="url(%23grid)"/></svg>');
            opacity: 0.3;
        }

        .hero-content {
            position: relative;
            z-index: 2;
        }

        .hero-title {
            font-family: 'Poppins', sans-serif;
            font-size: 3.5rem;
            font-weight: 800;
            color: var(--dark-blue);
            margin-bottom: 1.5rem;
            line-height: 1.2;
        }

        .hero-subtitle {
            font-size: 1.25rem;
            color: var(--medium-gray);
            margin-bottom: 2rem;
            font-weight: 400;
        }

        .hero-stats {
            display: flex;
            gap: 2rem;
            margin-top: 3rem;
        }

        .stat-item {
            text-align: center;
        }

        .stat-number {
            font-family: 'Poppins', sans-serif;
            font-size: 2rem;
            font-weight: 700;
            color: var(--primary-blue);
            display: block;
        }

        .stat-label {
            font-size: 0.875rem;
            color: var(--medium-gray);
            font-weight: 500;
        }

        /* Process Section */
        .process-section {
            padding: 80px 0;
            background: var(--pure-white);
        }

        .section-title {
            font-family: 'Poppins', sans-serif;
            font-size: 2.5rem;
            font-weight: 700;
            color: var(--dark-blue);
            text-align: center;
            margin-bottom: 1rem;
        }

        .section-subtitle {
            font-size: 1.125rem;
            color: var(--medium-gray);
            text-align: center;
            margin-bottom: 4rem;
            max-width: 600px;
            margin-left: auto;
            margin-right: auto;
        }

        .process-card {
            background: var(--pure-white);
            border-radius: 20px;
            padding: 2.5rem;
            text-align: center;
            box-shadow: var(--shadow-lg);
            border: 1px solid rgba(37, 99, 235, 0.1);
            transition: all 0.3s ease;
            height: 100%;
            position: relative;
            overflow: hidden;
        }

        .process-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 4px;
            background: var(--gradient-primary);
        }

        .process-card:hover {
            transform: translateY(-10px);
            box-shadow: var(--shadow-xl);
        }

        .process-number {
            width: 80px;
            height: 80px;
            background: var(--gradient-primary);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 1.5rem;
            font-family: 'Poppins', sans-serif;
            font-size: 1.5rem;
            font-weight: 700;
            color: white;
            box-shadow: var(--shadow-md);
        }

        .process-title {
            font-family: 'Poppins', sans-serif;
            font-size: 1.25rem;
            font-weight: 600;
            color: var(--dark-blue);
            margin-bottom: 1rem;
        }

        .process-description {
            color: var(--medium-gray);
            line-height: 1.6;
        }

        /* Services Section */
        .services-section {
            padding: 80px 0;
            background: var(--light-gray);
        }

        .service-card {
            background: var(--pure-white);
            border-radius: 16px;
            padding: 2rem;
            text-align: center;
            box-shadow: var(--shadow-md);
            transition: all 0.3s ease;
            height: 100%;
            border: 1px solid rgba(37, 99, 235, 0.05);
        }

        .service-card:hover {
            transform: translateY(-5px);
            box-shadow: var(--shadow-lg);
        }

        .service-icon {
            width: 70px;
            height: 70px;
            background: var(--light-blue);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 1.5rem;
            font-size: 1.5rem;
            color: var(--primary-blue);
        }

        .service-title {
            font-family: 'Poppins', sans-serif;
            font-size: 1.125rem;
            font-weight: 600;
            color: var(--dark-blue);
            margin-bottom: 1rem;
        }

        .service-description {
            color: var(--medium-gray);
            font-size: 0.875rem;
            line-height: 1.6;
        }

        /* Features Section */
        .features-section {
            padding: 80px 0;
            background: var(--pure-white);
        }

        .feature-item {
            display: flex;
            align-items: center;
            gap: 1rem;
            margin-bottom: 1.5rem;
        }

        .feature-icon {
            width: 50px;
            height: 50px;
            background: var(--light-blue);
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            color: var(--primary-blue);
            font-size: 1.25rem;
        }

        .feature-text {
            font-weight: 500;
            color: var(--dark-gray);
        }

        /* CTA Section */
        .cta-section {
            padding: 80px 0;
            background: var(--gradient-primary);
            color: white;
            text-align: center;
        }

        .cta-title {
            font-family: 'Poppins', sans-serif;
            font-size: 2.5rem;
            font-weight: 700;
            margin-bottom: 1rem;
        }

        .cta-subtitle {
            font-size: 1.125rem;
            margin-bottom: 2rem;
            opacity: 0.9;
        }

        .modern-btn-white {
            background: white;
            color: var(--primary-blue);
            border: none;
            padding: 1rem 2rem;
            border-radius: 12px;
            font-weight: 600;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
            transition: all 0.3s ease;
            box-shadow: var(--shadow-md);
        }

        .modern-btn-white:hover {
            transform: translateY(-2px);
            box-shadow: var(--shadow-lg);
            color: var(--primary-blue);
        }

        /* Footer */
        .modern-footer {
            background: var(--dark-blue);
            color: white;
            padding: 60px 0 30px;
        }

        .footer-section h5 {
            font-family: 'Poppins', sans-serif;
            font-weight: 600;
            margin-bottom: 1.5rem;
            color: white;
        }

        .footer-section ul {
            list-style: none;
            padding: 0;
        }

        .footer-section ul li {
            margin-bottom: 0.5rem;
        }

        .footer-section ul li a {
            color: rgba(255, 255, 255, 0.8);
            text-decoration: none;
            transition: color 0.3s ease;
        }

        .footer-section ul li a:hover {
            color: white;
        }

        .footer-bottom {
            border-top: 1px solid rgba(255, 255, 255, 0.1);
            margin-top: 3rem;
            padding-top: 2rem;
            text-align: center;
            color: rgba(255, 255, 255, 0.7);
        }

        /* Responsive Design */
        @media (max-width: 768px) {
            .hero-title {
                font-size: 2.5rem;
            }

            .hero-stats {
                flex-direction: column;
                gap: 1rem;
            }

            .section-title {
                font-size: 2rem;
            }

            .process-card {
                margin-bottom: 2rem;
            }
        }

        /* Animations */
        @keyframes fadeInUp {
            from {
                opacity: 0;
                transform: translateY(30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .animate-fade-in-up {
            animation: fadeInUp 0.6s ease-out;
        }

        /* Scroll Indicator */
        .scroll-indicator {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 3px;
            background: rgba(37, 99, 235, 0.2);
            z-index: 9999;
        }

        .scroll-progress {
            height: 100%;
            background: var(--gradient-primary);
            width: 0%;
            transition: width 0.1s ease;
        }
    </style>
</head>
<body>
    <!-- Scroll Indicator -->
    <div class="scroll-indicator">
        <div class="scroll-progress" id="scrollProgress"></div>
    </div>

    <!-- Modern Navigation -->
    <nav class="navbar navbar-expand-lg modern-navbar fixed-top" id="mainNavbar">
        <div class="container">
            <a class="navbar-brand" href="#home">
                <i class="fas fa-car me-2"></i>
                Araç Bakım Servisi
            </a>
            <button class="navbar-toggler border-0" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <i class="fas fa-bars text-primary"></i>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ms-auto">
                    <li class="nav-item">
                        <a class="nav-link active" href="#home">Ana Sayfa</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#process">Nasıl Çalışır</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#services">Hizmetlerimiz</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#features">Özellikler</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#contact">İletişim</a>
                    </li>
                    <li class="nav-item ms-2">
                        <a class="modern-btn" href="quote_form.php">
                            <i class="fas fa-paper-plane"></i>Teklif Al
                        </a>
                    </li>
                </ul>
            </div>
        </div>
    </nav>

    <!-- Hero Section -->
    <section id="home" class="hero-section">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-6">
                    <div class="hero-content animate-fade-in-up">
                        <h1 class="hero-title">
                            Aracınız İçin
                            <span style="color: var(--primary-blue);">Profesyonel</span>
                            Bakım Hizmeti
                        </h1>
                        <p class="hero-subtitle">
                            Uzman ekibimiz ve modern teknolojimizle aracınızın bakım ve onarım ihtiyaçlarını karşılıyor, 
                            size güvenli ve konforlu bir sürüş deneyimi sunuyoruz.
                        </p>
                        <div class="d-flex flex-wrap gap-3">
                            <a href="quote_form.php" class="modern-btn">
                                <i class="fas fa-calculator"></i>
                                Ücretsiz Teklif Al
                            </a>
                            <a href="#process" class="modern-btn-outline">
                                <i class="fas fa-play-circle"></i>
                                Nasıl Çalışır?
                            </a>
                        </div>
                        <div class="hero-stats">
                            <div class="stat-item">
                                <span class="stat-number">1000+</span>
                                <span class="stat-label">Mutlu Müşteri</span>
                            </div>
                            <div class="stat-item">
                                <span class="stat-number">5000+</span>
                                <span class="stat-label">Tamamlanan İş</span>
                            </div>
                            <div class="stat-item">
                                <span class="stat-number">15+</span>
                                <span class="stat-label">Yıl Deneyim</span>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="text-center">
                        <i class="fas fa-car-side" style="font-size: 20rem; color: var(--primary-blue); opacity: 0.1;"></i>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Process Section -->
    <section id="process" class="process-section">
        <div class="container">
            <div class="text-center mb-5">
                <h2 class="section-title">Nasıl Çalışır?</h2>
                <p class="section-subtitle">
                    Sadece 3 basit adımda aracınız için profesyonel bakım hizmeti alın
                </p>
            </div>
            <div class="row g-4">
                <div class="col-lg-4 col-md-6">
                    <div class="process-card animate-fade-in-up">
                        <div class="process-number">1</div>
                        <h3 class="process-title">Teklif Formu Doldurun</h3>
                        <p class="process-description">
                            Aracınızın bilgilerini ve ihtiyacınız olan hizmetleri belirterek 
                            online teklif formunu doldurun. Sadece birkaç dakika sürer.
                        </p>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6">
                    <div class="process-card animate-fade-in-up" style="animation-delay: 0.2s;">
                        <div class="process-number">2</div>
                        <h3 class="process-title">Detaylı Teklif Alın</h3>
                        <p class="process-description">
                            Uzman ekibimiz aracınızın ihtiyaçlarını değerlendirerek 
                            size özel detaylı bir teklif hazırlar ve 24 saat içinde iletir.
                        </p>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6">
                    <div class="process-card animate-fade-in-up" style="animation-delay: 0.4s;">
                        <div class="process-number">3</div>
                        <h3 class="process-title">Ödeme Yapın & Hizmet Alın</h3>
                        <p class="process-description">
                            Teklifimizi beğendiyseniz güvenli ödeme sistemiyle ödemenizi yapın 
                            ve randevu alarak profesyonel hizmetimizden faydalanın.
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Services Section -->
    <section id="services" class="services-section">
        <div class="container">
            <div class="text-center mb-5">
                <h2 class="section-title">Hizmetlerimiz</h2>
                <p class="section-subtitle">
                    Aracınızın tüm bakım ve onarım ihtiyaçları için kapsamlı hizmet yelpazesi
                </p>
            </div>
            <div class="row g-4">
                <div class="col-lg-3 col-md-6">
                    <div class="service-card">
                        <div class="service-icon">
                            <i class="fas fa-oil-can"></i>
                        </div>
                        <h4 class="service-title">Periyodik Bakım</h4>
                        <p class="service-description">
                            Yağ değişimi, filtre değişimi ve genel kontroller ile aracınızın performansını koruyun.
                        </p>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6">
                    <div class="service-card">
                        <div class="service-icon">
                            <i class="fas fa-wrench"></i>
                        </div>
                        <h4 class="service-title">Motor Onarımı</h4>
                        <p class="service-description">
                            Uzman teknisyenlerimizle motor arızalarınızı hızlı ve güvenilir şekilde çözüyoruz.
                        </p>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6">
                    <div class="service-card">
                        <div class="service-icon">
                            <i class="fas fa-car-crash"></i>
                        </div>
                        <h4 class="service-title">Kaporta & Boya</h4>
                        <p class="service-description">
                            Aracınızın dış görünümünü yenileyen profesyonel kaporta ve boya hizmetleri.
                        </p>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6">
                    <div class="service-card">
                        <div class="service-icon">
                            <i class="fas fa-cog"></i>
                        </div>
                        <h4 class="service-title">Genel Onarım</h4>
                        <p class="service-description">
                            Fren sistemi, süspansiyon ve diğer tüm mekanik onarım işlemleri.
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Features Section -->
    <section id="features" class="features-section">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-6">
                    <h2 class="section-title text-start">Neden Bizi Tercih Etmelisiniz?</h2>
                    <p class="section-subtitle text-start">
                        Müşteri memnuniyeti odaklı hizmet anlayışımızla fark yaratıyoruz
                    </p>
                    <div class="feature-item">
                        <div class="feature-icon">
                            <i class="fas fa-certificate"></i>
                        </div>
                        <div class="feature-text">15+ yıl sektör deneyimi ve uzman ekip</div>
                    </div>
                    <div class="feature-item">
                        <div class="feature-icon">
                            <i class="fas fa-tools"></i>
                        </div>
                        <div class="feature-text">Modern ekipman ve orijinal yedek parça kullanımı</div>
                    </div>
                    <div class="feature-item">
                        <div class="feature-icon">
                            <i class="fas fa-shield-alt"></i>
                        </div>
                        <div class="feature-text">Tüm işlemler için garanti ve sigorta</div>
                    </div>
                    <div class="feature-item">
                        <div class="feature-icon">
                            <i class="fas fa-clock"></i>
                        </div>
                        <div class="feature-text">Hızlı teslimat ve 7/24 destek hizmeti</div>
                    </div>
                    <div class="feature-item">
                        <div class="feature-icon">
                            <i class="fas fa-money-bill-wave"></i>
                        </div>
                        <div class="feature-text">Şeffaf fiyatlandırma ve uygun ödeme seçenekleri</div>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="text-center">
                        <i class="fas fa-car-mechanic" style="font-size: 15rem; color: var(--light-blue);"></i>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- CTA Section -->
    <section class="cta-section">
        <div class="container">
            <h2 class="cta-title">Aracınız İçin Hemen Teklif Alın!</h2>
            <p class="cta-subtitle">
                Profesyonel bakım hizmetimizden faydalanmak için bugün başvurun
            </p>
            <a href="quote_form.php" class="modern-btn-white">
                <i class="fas fa-paper-plane"></i>
                Ücretsiz Teklif Al
            </a>
        </div>
    </section>

    <!-- Footer -->
    <footer id="contact" class="modern-footer">
        <div class="container">
            <div class="row">
                <div class="col-lg-4 col-md-6">
                    <div class="footer-section">
                        <h5>
                            <i class="fas fa-car me-2"></i>
                            Araç Bakım Servisi
                        </h5>
                        <p style="color: rgba(255, 255, 255, 0.8);">
                            Profesyonel araç bakım ve onarım hizmetleri ile aracınızın performansını 
                            en üst seviyede tutuyoruz.
                        </p>
                    </div>
                </div>
                <div class="col-lg-2 col-md-6">
                    <div class="footer-section">
                        <h5>Hizmetler</h5>
                        <ul>
                            <li><a href="#services">Periyodik Bakım</a></li>
                            <li><a href="#services">Motor Onarımı</a></li>
                            <li><a href="#services">Kaporta & Boya</a></li>
                            <li><a href="#services">Genel Onarım</a></li>
                        </ul>
                    </div>
                </div>
                <div class="col-lg-2 col-md-6">
                    <div class="footer-section">
                        <h5>Kurumsal</h5>
                        <ul>
                            <li><a href="about.php">Hakkımızda</a></li>
                            <li><a href="#features">Neden Biz?</a></li>
                            <li><a href="contact.php">İletişim</a></li>
                            <li><a href="admin/login.php">Admin Girişi</a></li>
                        </ul>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6">
                    <div class="footer-section">
                        <h5>İletişim</h5>
                        <div style="color: rgba(255, 255, 255, 0.8);">
                            <p><i class="fas fa-map-marker-alt me-2"></i> İstanbul, Türkiye</p>
                            <p><i class="fas fa-phone me-2"></i> +90 532 123 45 67</p>
                            <p><i class="fas fa-envelope me-2"></i> info@aracbakim.com</p>
                            <p><i class="fas fa-clock me-2"></i> Pazartesi - Cumartesi: 09:00 - 18:00</p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="footer-bottom">
                <p>&copy; 2024 Araç Bakım Servisi. Tüm hakları saklıdır.</p>
            </div>
        </div>
    </footer>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Navbar scroll effect
        window.addEventListener('scroll', function() {
            const navbar = document.getElementById('mainNavbar');
            if (window.scrollY > 50) {
                navbar.classList.add('scrolled');
            } else {
                navbar.classList.remove('scrolled');
            }
        });

        // Scroll progress indicator
        window.addEventListener('scroll', function() {
            const scrollProgress = document.getElementById('scrollProgress');
            const scrollTop = document.documentElement.scrollTop;
            const scrollHeight = document.documentElement.scrollHeight - document.documentElement.clientHeight;
            const scrollPercentage = (scrollTop / scrollHeight) * 100;
            scrollProgress.style.width = scrollPercentage + '%';
        });

        // Smooth scrolling for navigation links
        document.querySelectorAll('a[href^="#"]').forEach(anchor => {
            anchor.addEventListener('click', function (e) {
                e.preventDefault();
                const target = document.querySelector(this.getAttribute('href'));
                if (target) {
                    target.scrollIntoView({
                        behavior: 'smooth',
                        block: 'start'
                    });
                }
            });
        });

        // Active navigation link
        window.addEventListener('scroll', function() {
            const sections = document.querySelectorAll('section[id]');
            const navLinks = document.querySelectorAll('.navbar-nav .nav-link');
            
            let current = '';
            sections.forEach(section => {
                const sectionTop = section.getBoundingClientRect().top;
                if (sectionTop <= 100) {
                    current = section.getAttribute('id');
                }
            });

            navLinks.forEach(link => {
                link.classList.remove('active');
                if (link.getAttribute('href') === '#' + current) {
                    link.classList.add('active');
                }
            });
        });

        // Animation on scroll
        const observerOptions = {
            threshold: 0.1,
            rootMargin: '0px 0px -50px 0px'
        };

        const observer = new IntersectionObserver(function(entries) {
            entries.forEach(entry => {
                if (entry.isIntersecting) {
                    entry.target.style.opacity = '1';
                    entry.target.style.transform = 'translateY(0)';
                }
            });
        }, observerOptions);

        // Observe all cards and sections
        document.querySelectorAll('.process-card, .service-card').forEach(el => {
            el.style.opacity = '0';
            el.style.transform = 'translateY(30px)';
            el.style.transition = 'all 0.6s ease';
            observer.observe(el);
        });
    </script>
</body>
</html>