-- ARAÇ BAKIM SERVİSİ - BASİT VERSİYON (Foreign Key'siz)
-- Türkçe karakter desteği ile - Foreign key constraint sorunları olmadan

-- Veritabanı karakter seti ayarları
SET NAMES utf8mb4;
SET CHARACTER SET utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;

-- Veritabanı oluştur
CREATE DATABASE IF NOT EXISTS aracbakim CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
USE aracbakim;

-- Kullanıcılar tablosu
CREATE TABLE users (
    id INT PRIMARY KEY AUTO_INCREMENT,
    username VARCHAR(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci UNIQUE NOT NULL,
    email VARCHAR(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci UNIQUE NOT NULL,
    password_hash VARCHAR(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
    first_name VARCHAR(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
    last_name VARCHAR(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
    role ENUM('admin', 'advisor', 'manager') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'advisor',
    phone VARCHAR(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
    is_active BOOLEAN DEFAULT TRUE,
    last_login TIMESTAMP NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Müşteriler tablosu
CREATE TABLE customers (
    id INT PRIMARY KEY AUTO_INCREMENT,
    first_name VARCHAR(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
    last_name VARCHAR(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
    phone VARCHAR(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
    email VARCHAR(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
    phone_verified BOOLEAN DEFAULT FALSE,
    phone_verification_code VARCHAR(6) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
    phone_verification_expires TIMESTAMP NULL,
    kvkk_consent BOOLEAN DEFAULT FALSE,
    kvkk_consent_date TIMESTAMP NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    INDEX idx_phone (phone),
    INDEX idx_email (email)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Araçlar tablosu
CREATE TABLE vehicles (
    id INT PRIMARY KEY AUTO_INCREMENT,
    customer_id INT NOT NULL,
    brand VARCHAR(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
    model VARCHAR(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
    year YEAR NOT NULL,
    plate VARCHAR(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
    engine_size VARCHAR(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
    fuel_type VARCHAR(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
    transmission VARCHAR(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
    mileage INT,
    notes TEXT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    INDEX idx_customer (customer_id),
    INDEX idx_plate (plate)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Ürün kategorileri tablosu
CREATE TABLE product_categories (
    id INT PRIMARY KEY AUTO_INCREMENT,
    name VARCHAR(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
    description TEXT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
    parent_id INT NULL,
    is_active BOOLEAN DEFAULT TRUE,
    sort_order INT DEFAULT 0,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    INDEX idx_parent (parent_id),
    INDEX idx_active (is_active)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Ürünler/Hizmetler tablosu
CREATE TABLE products (
    id INT PRIMARY KEY AUTO_INCREMENT,
    category_id INT,
    name VARCHAR(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
    description TEXT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
    type ENUM('part', 'service', 'package') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
    sku VARCHAR(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci UNIQUE,
    price DECIMAL(10,2) NOT NULL,
    cost_price DECIMAL(10,2),
    stock_quantity INT DEFAULT 0,
    min_stock_level INT DEFAULT 0,
    is_active BOOLEAN DEFAULT TRUE,
    requires_vehicle_info BOOLEAN DEFAULT FALSE,
    estimated_duration INT,
    warranty_period INT,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    INDEX idx_category (category_id),
    INDEX idx_sku (sku),
    INDEX idx_type (type)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Teklif başvuruları tablosu
CREATE TABLE quote_requests (
    id INT PRIMARY KEY AUTO_INCREMENT,
    customer_id INT NOT NULL,
    vehicle_id INT NOT NULL,
    service_type VARCHAR(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
    problem_description TEXT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
    preferred_date VARCHAR(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
    preferred_time VARCHAR(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
    additional_notes TEXT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
    status ENUM('NEW', 'IN_PROGRESS', 'QUOTE_SENT', 'ACCEPTED', 'REJECTED', 'EXPIRED', 'CANCELLED') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'NEW',
    assigned_to INT NULL,
    admin_notes TEXT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    INDEX idx_status (status),
    INDEX idx_customer (customer_id),
    INDEX idx_assigned (assigned_to)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Teklifler tablosu
CREATE TABLE quotes (
    id INT PRIMARY KEY AUTO_INCREMENT,
    quote_request_id INT NOT NULL,
    quote_number VARCHAR(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci UNIQUE NOT NULL,
    quote_token VARCHAR(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci UNIQUE NOT NULL,
    subtotal DECIMAL(10,2) NOT NULL DEFAULT 0,
    discount_amount DECIMAL(10,2) DEFAULT 0,
    discount_percentage DECIMAL(5,2) DEFAULT 0,
    tax_rate DECIMAL(5,4) DEFAULT 0.18,
    tax_amount DECIMAL(10,2) NOT NULL DEFAULT 0,
    total_amount DECIMAL(10,2) NOT NULL DEFAULT 0,
    valid_until TIMESTAMP NOT NULL,
    terms_conditions TEXT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
    internal_notes TEXT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
    created_by INT NOT NULL,
    sent_at TIMESTAMP NULL,
    viewed_at TIMESTAMP NULL,
    accepted_at TIMESTAMP NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    INDEX idx_token (quote_token),
    INDEX idx_number (quote_number),
    INDEX idx_request (quote_request_id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Teklif kalemleri tablosu
CREATE TABLE quote_items (
    id INT PRIMARY KEY AUTO_INCREMENT,
    quote_id INT NOT NULL,
    product_id INT NULL,
    name VARCHAR(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
    description TEXT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
    quantity INT NOT NULL DEFAULT 1,
    unit_price DECIMAL(10,2) NOT NULL,
    discount_amount DECIMAL(10,2) DEFAULT 0,
    tax_rate DECIMAL(5,4) DEFAULT 0.18,
    line_total DECIMAL(10,2) NOT NULL,
    sort_order INT DEFAULT 0,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    INDEX idx_quote (quote_id),
    INDEX idx_product (product_id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Siparişler tablosu
CREATE TABLE orders (
    id INT PRIMARY KEY AUTO_INCREMENT,
    quote_id INT NOT NULL,
    order_number VARCHAR(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci UNIQUE NOT NULL,
    customer_id INT NOT NULL,
    status ENUM('pending', 'confirmed', 'in_progress', 'completed', 'cancelled') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'pending',
    subtotal DECIMAL(10,2) NOT NULL,
    discount_amount DECIMAL(10,2) DEFAULT 0,
    tax_amount DECIMAL(10,2) NOT NULL,
    total_amount DECIMAL(10,2) NOT NULL,
    customer_notes TEXT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
    admin_notes TEXT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
    estimated_completion TIMESTAMP NULL,
    completed_at TIMESTAMP NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    INDEX idx_status (status),
    INDEX idx_customer (customer_id),
    INDEX idx_number (order_number)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Sipariş kalemleri tablosu
CREATE TABLE order_items (
    id INT PRIMARY KEY AUTO_INCREMENT,
    order_id INT NOT NULL,
    product_id INT NULL,
    name VARCHAR(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
    description TEXT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
    quantity INT NOT NULL,
    unit_price DECIMAL(10,2) NOT NULL,
    line_total DECIMAL(10,2) NOT NULL,
    status ENUM('pending', 'in_progress', 'completed') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'pending',
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    INDEX idx_order (order_id),
    INDEX idx_product (product_id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Ödemeler tablosu
CREATE TABLE payments (
    id INT PRIMARY KEY AUTO_INCREMENT,
    order_id INT NOT NULL,
    payment_method VARCHAR(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
    amount DECIMAL(10,2) NOT NULL,
    currency VARCHAR(3) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'TRY',
    status ENUM('pending', 'processing', 'completed', 'failed', 'cancelled', 'refunded') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'pending',
    transaction_id VARCHAR(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
    gateway_response TEXT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
    failure_reason TEXT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
    processed_at TIMESTAMP NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    INDEX idx_order (order_id),
    INDEX idx_status (status),
    INDEX idx_transaction (transaction_id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Sistem ayarları tablosu
CREATE TABLE settings (
    id INT PRIMARY KEY AUTO_INCREMENT,
    setting_key VARCHAR(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL UNIQUE,
    setting_value TEXT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
    description TEXT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
    category VARCHAR(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'general',
    is_public BOOLEAN DEFAULT FALSE,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    INDEX idx_category (category),
    INDEX idx_public (is_public)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Audit log tablosu
CREATE TABLE audit_logs (
    id INT PRIMARY KEY AUTO_INCREMENT,
    user_id INT NULL,
    action VARCHAR(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
    table_name VARCHAR(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
    record_id INT,
    old_values JSON,
    new_values JSON,
    ip_address VARCHAR(45) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
    user_agent TEXT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    INDEX idx_user (user_id),
    INDEX idx_action (action),
    INDEX idx_table (table_name),
    INDEX idx_created (created_at)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Foreign key kontrolünü tekrar aç
SET FOREIGN_KEY_CHECKS = 1;

-- VARSAYILAN VERİLER

-- Admin kullanıcı (şifre: password)
INSERT INTO users (username, email, password_hash, first_name, last_name, role) VALUES
('admin', 'admin@aracbakim.com', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'Admin', 'Kullanıcı', 'admin');

-- Ürün kategorileri (Türkçe karakterlerle)
INSERT INTO product_categories (name, description) VALUES
('Motor Bakım', 'Motor yağı, filtre ve genel motor bakım hizmetleri'),
('Fren Sistemi', 'Fren balata, disk ve fren sistemi bakımı'),
('Süspansiyon', 'Amortisör, yay ve süspansiyon parçaları'),
('Elektrik Sistemi', 'Akü, alternatör ve elektriksel parçalar'),
('Klima Sistemi', 'Klima gazı, filtre ve klima bakımı'),
('Lastik ve Jant', 'Lastik değişimi, balans ve rot ayarı'),
('Kaportaj', 'Boyama, çizik giderme ve kaportaj işlemleri'),
('Paket Hizmetler', 'Kombine bakım paketleri');

-- Örnek ürünler (Türkçe karakterlerle)
INSERT INTO products (category_id, name, description, type, price) VALUES
(1, 'Motor Yağı Değişimi', 'Sentetik motor yağı ile değişim hizmeti', 'service', 150.00),
(1, 'Hava Filtresi Değişimi', 'Motor hava filtresinin değişimi', 'service', 80.00),
(2, 'Fren Balata Değişimi', 'Ön/arka fren balata değişimi', 'service', 300.00),
(2, 'Fren Diski Değişimi', 'Fren disklerinin değişimi', 'service', 400.00),
(3, 'Amortisör Değişimi', 'Ön/arka amortisör değişimi', 'service', 500.00),
(4, 'Akü Değişimi', 'Araç akü değişimi ve kontrolü', 'service', 250.00),
(5, 'Klima Gazı Dolumu', 'Klima gazı kontrolü ve dolumu', 'service', 120.00),
(6, 'Lastik Değişimi', '4 lastik değişimi ve balans', 'service', 200.00),
(8, 'Genel Bakım Paketi', 'Yağ, filtre, kontrol paketi', 'package', 400.00),
(8, 'Kış Bakım Paketi', 'Kış hazırlık bakım paketi', 'package', 350.00);

-- Sistem ayarları (Türkçe karakterlerle)
INSERT INTO settings (setting_key, setting_value, description, category) VALUES
('site_name', 'Araç Bakım Servisi', 'Site adı', 'general'),
('site_description', 'Profesyonel araç bakım ve onarım hizmetleri', 'Site açıklaması', 'general'),
('contact_phone', '0212 123 45 67', 'İletişim telefonu', 'contact'),
('contact_email', 'info@aracbakim.com', 'İletişim e-posta', 'contact'),
('contact_address', 'Örnek Mahalle, Araç Bakım Caddesi No:123, İstanbul', 'Adres bilgisi', 'contact'),
('working_hours', 'Pazartesi-Cumartesi: 08:00-18:00', 'Çalışma saatleri', 'contact'),
('quote_validity_hours', '48', 'Teklif geçerlilik süresi (saat)', 'business'),
('default_tax_rate', '0.18', 'Varsayılan KDV oranı', 'business'),
('currency', 'TRY', 'Para birimi', 'business'),
('timezone', 'Europe/Istanbul', 'Zaman dilimi', 'general');

-- Türkçe karakter testi
SELECT 'VERİTABANI BAŞARIYLA OLUŞTURULDU! 🎉' as SONUC;
SELECT 'Türkçe karakterler: ğüşıöç ĞÜŞIÖÇ' as KARAKTER_TEST;
SELECT 'Emoji desteği: 🚗 🔧 ⚙️ 📧 📱' as EMOJI_TEST;
