<?php
session_start();
require_once '../config/config.php';
require_once '../includes/functions.php';
require_once '../includes/email_functions.php';

$pageTitle = 'E-posta Test';
$currentPage = 'test_email';

if (!isLoggedIn()) {
    redirect('login.php');
}

$message = '';
$messageType = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $test_email = trim($_POST['test_email'] ?? '');
    
    if (empty($test_email)) {
        $message = 'Lütfen test e-posta adresi girin.';
        $messageType = 'danger';
    } elseif (!filter_var($test_email, FILTER_VALIDATE_EMAIL)) {
        $message = 'Geçerli bir e-posta adresi girin.';
        $messageType = 'danger';
    } else {
        try {
            $result = sendTestEmail($test_email);
            
            if ($result) {
                $message = "Test e-postası başarıyla gönderildi: $test_email";
                $messageType = 'success';
                
                // Audit log
                logAudit('test_email_sent', 'system', null, null, [
                    'recipient' => $test_email,
                    'sent_by' => $_SESSION['user_id']
                ]);
            } else {
                $message = 'E-posta gönderilemedi. Lütfen ayarlarınızı kontrol edin.';
                $messageType = 'danger';
            }
        } catch (Exception $e) {
            $message = 'Hata: ' . $e->getMessage();
            $messageType = 'danger';
            error_log("Test email error: " . $e->getMessage());
        }
    }
}

include 'includes/header.php';
?>

<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="nice-card">
                <div class="card-header">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-envelope-open-text text-primary me-2"></i>
                        E-posta Sistem Testi
                    </h5>
                </div>
                
                <div class="card-body">
                    <?php if ($message): ?>
                    <div class="alert alert-<?= $messageType ?> alert-dismissible fade show" role="alert">
                        <?= htmlspecialchars($message) ?>
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                    <?php endif; ?>
                    
                    <!-- E-posta Ayarları Durumu -->
                    <div class="row mb-4">
                        <div class="col-md-6">
                            <div class="nice-card bg-light">
                                <div class="card-body">
                                    <h6 class="card-title">
                                        <i class="fas fa-cog text-info me-2"></i>
                                        Mevcut E-posta Ayarları
                                    </h6>
                                    
                                    <div class="mb-2">
                                        <strong>SMTP Host:</strong> 
                                        <span class="<?= defined('SMTP_HOST') && SMTP_HOST !== 'smtp.gmail.com' ? 'text-success' : 'text-warning' ?>">
                                            <?= defined('SMTP_HOST') ? SMTP_HOST : 'Tanımlı değil' ?>
                                        </span>
                                    </div>
                                    
                                    <div class="mb-2">
                                        <strong>SMTP Port:</strong> 
                                        <span class="text-info">
                                            <?= defined('SMTP_PORT') ? SMTP_PORT : 'Tanımlı değil' ?>
                                        </span>
                                    </div>
                                    
                                    <div class="mb-2">
                                        <strong>SMTP Username:</strong> 
                                        <span class="<?= defined('SMTP_USERNAME') && SMTP_USERNAME !== 'your_email@gmail.com' ? 'text-success' : 'text-warning' ?>">
                                            <?= defined('SMTP_USERNAME') ? SMTP_USERNAME : 'Tanımlı değil' ?>
                                        </span>
                                    </div>
                                    
                                    <div class="mb-2">
                                        <strong>SMTP Password:</strong> 
                                        <span class="<?= defined('SMTP_PASSWORD') && SMTP_PASSWORD !== 'your_app_password' ? 'text-success' : 'text-warning' ?>">
                                            <?php if (defined('SMTP_PASSWORD') && SMTP_PASSWORD !== 'your_app_password'): ?>
                                                ✓ Yapılandırılmış
                                            <?php else: ?>
                                                ⚠ Yapılandırılmamış
                                            <?php endif; ?>
                                        </span>
                                    </div>
                                    
                                    <div class="mb-2">
                                        <strong>Admin Email:</strong> 
                                        <span class="text-info">
                                            <?= defined('ADMIN_EMAIL') ? ADMIN_EMAIL : 'Tanımlı değil' ?>
                                        </span>
                                    </div>
                                    
                                    <div class="mb-2">
                                        <strong>PHPMailer:</strong> 
                                        <span class="<?= class_exists('PHPMailer\PHPMailer\PHPMailer') ? 'text-success' : 'text-danger' ?>">
                                            <?php if (class_exists('PHPMailer\PHPMailer\PHPMailer')): ?>
                                                ✓ Yüklü (v<?= PHPMailer\PHPMailer\PHPMailer::VERSION ?>)
                                            <?php else: ?>
                                                ✗ Yüklü değil
                                            <?php endif; ?>
                                        </span>
                                    </div>
                                    
                                    <div class="mb-2">
                                        <strong>PHPMailer Sınıfları:</strong>
                                        <div class="small mt-1">
                                            <span class="badge bg-<?= class_exists('PHPMailer\PHPMailer\Exception') ? 'success' : 'danger' ?>">
                                                Exception <?= class_exists('PHPMailer\PHPMailer\Exception') ? '✓' : '✗' ?>
                                            </span>
                                            <span class="badge bg-<?= class_exists('PHPMailer\PHPMailer\SMTP') ? 'success' : 'danger' ?>">
                                                SMTP <?= class_exists('PHPMailer\PHPMailer\SMTP') ? '✓' : '✗' ?>
                                            </span>
                                            <span class="badge bg-<?= class_exists('PHPMailer\PHPMailer\PHPMailer') ? 'success' : 'danger' ?>">
                                                PHPMailer <?= class_exists('PHPMailer\PHPMailer\PHPMailer') ? '✓' : '✗' ?>
                                            </span>
                                        </div>
                                    </div>
                                    
                                    <div class="mb-0">
                                        <strong>PHPMailer Loader:</strong> 
                                        <span class="<?= file_exists('../phpmailer_loader.php') ? 'text-success' : 'text-warning' ?>">
                                            <?= file_exists('../phpmailer_loader.php') ? '✓ Mevcut' : '⚠ Bulunamadı' ?>
                                        </span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="nice-card bg-light">
                                <div class="card-body">
                                    <h6 class="card-title">
                                        <i class="fas fa-info-circle text-primary me-2"></i>
                                        Kurulum Durumu
                                    </h6>
                                    
                                    <?php
                                    $smtp_configured = defined('SMTP_HOST') && defined('SMTP_USERNAME') && defined('SMTP_PASSWORD') &&
                                                      SMTP_HOST !== 'smtp.gmail.com' && SMTP_USERNAME !== 'your_email@gmail.com' && 
                                                      SMTP_PASSWORD !== 'your_app_password';
                                    
                                    $phpmailer_available = class_exists('PHPMailer\PHPMailer\PHPMailer');
                                    ?>
                                    
                                    <div class="mb-2">
                                        <i class="fas fa-<?= $smtp_configured ? 'check-circle text-success' : 'exclamation-triangle text-warning' ?>"></i>
                                        SMTP Ayarları: 
                                        <strong class="<?= $smtp_configured ? 'text-success' : 'text-warning' ?>">
                                            <?= $smtp_configured ? 'Yapılandırılmış' : 'Yapılandırılmamış' ?>
                                        </strong>
                                    </div>
                                    
                                    <div class="mb-2">
                                        <i class="fas fa-<?= $phpmailer_available ? 'check-circle text-success' : 'times-circle text-danger' ?>"></i>
                                        PHPMailer: 
                                        <strong class="<?= $phpmailer_available ? 'text-success' : 'text-danger' ?>">
                                            <?php if ($phpmailer_available): ?>
                                                Kullanılabilir (v<?= PHPMailer\PHPMailer\PHPMailer::VERSION ?>)
                                            <?php else: ?>
                                                Yüklü değil
                                            <?php endif; ?>
                                        </strong>
                                    </div>
                                    
                                    <div class="mb-3">
                                        <i class="fas fa-info-circle text-info"></i>
                                        Yedek Sistem: 
                                        <strong class="text-info">PHP mail() fonksiyonu</strong>
                                    </div>
                                    
                                    <!-- PHPMailer Nesne Testi -->
                                    <?php if ($phpmailer_available): ?>
                                    <div class="alert alert-info mb-2">
                                        <small>
                                            <i class="fas fa-info-circle me-1"></i>
                                            <strong>PHPMailer Nesne Testi:</strong>
                                            <?php
                                            try {
                                                $test_mail = new PHPMailer\PHPMailer\PHPMailer(true);
                                                echo '<span class="text-success">✓ Nesne başarıyla oluşturuldu</span>';
                                            } catch (Exception $e) {
                                                echo '<span class="text-danger">✗ Nesne oluşturulamadı: ' . $e->getMessage() . '</span>';
                                            }
                                            ?>
                                        </small>
                                    </div>
                                    <?php endif; ?>
                                    
                                    <?php if (!$smtp_configured): ?>
                                    <div class="alert alert-warning mb-0">
                                        <small>
                                            <i class="fas fa-exclamation-triangle me-1"></i>
                                            SMTP ayarları yapılandırılmamış. 
                                            <code>config/config.php</code> dosyasını düzenleyin.
                                        </small>
                                    </div>
                                    <?php elseif ($phpmailer_available): ?>
                                    <div class="alert alert-success mb-0">
                                        <small>
                                            <i class="fas fa-check-circle me-1"></i>
                                            E-posta sistemi tamamen hazır! Test e-postası gönderebilirsiniz.
                                        </small>
                                    </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Test Formu -->
                    <div class="row">
                        <div class="col-md-8 mx-auto">
                            <form method="POST" class="needs-validation" novalidate>
                                <div class="mb-4">
                                    <label for="test_email" class="form-label">
                                        <i class="fas fa-envelope me-2"></i>
                                        Test E-posta Adresi
                                    </label>
                                    <input type="email" class="nice-form-control" id="test_email" name="test_email" 
                                           placeholder="test@example.com" required 
                                           value="<?= htmlspecialchars($_POST['test_email'] ?? '') ?>">
                                    <div class="form-text">
                                        Bu adrese bir test e-postası gönderilecek.
                                    </div>
                                    <div class="invalid-feedback">
                                        Lütfen geçerli bir e-posta adresi girin.
                                    </div>
                                </div>
                                
                                <div class="d-grid gap-2 d-md-flex justify-content-md-center">
                                    <button type="submit" class="nice-btn nice-btn-primary">
                                        <i class="fas fa-paper-plane me-2"></i>
                                        Test E-postası Gönder
                                    </button>
                                    <a href="dashboard.php" class="nice-btn nice-btn-outline-secondary">
                                        <i class="fas fa-arrow-left me-2"></i>
                                        Dashboard'a Dön
                                    </a>
                                </div>
                            </form>
                        </div>
                    </div>
                    
                    <!-- Kurulum Rehberi -->
                    <div class="row mt-5">
                        <div class="col-12">
                            <div class="nice-card bg-light">
                                <div class="card-body">
                                    <h6 class="card-title">
                                        <i class="fas fa-book text-success me-2"></i>
                                        Hızlı Kurulum Rehberi
                                    </h6>
                                    
                                    <div class="row">
                                        <div class="col-md-6">
                                            <h6 class="text-primary">1. PHPMailer Kurulumu ✅</h6>
                                            <div class="alert alert-success py-2 mb-2">
                                                <small>
                                                    <i class="fas fa-check-circle me-1"></i>
                                                    PHPMailer v<?= class_exists('PHPMailer\PHPMailer\PHPMailer') ? PHPMailer\PHPMailer\PHPMailer::VERSION : '?' ?> başarıyla yüklendi!
                                                </small>
                                            </div>
                                            <pre class="bg-dark text-light p-2 rounded small"><code># Manuel kurulum yapıldı:
vendor/phpmailer/phpmailer/
phpmailer_loader.php</code></pre>
                                            
                                            <h6 class="text-primary mt-3">2. Gmail Ayarları</h6>
                                            <ul class="small">
                                                <li>Google hesabınızda 2FA'yı aktif edin</li>
                                                <li><a href="https://myaccount.google.com/apppasswords" target="_blank">App Password</a> oluşturun</li>
                                                <li>16 karakterlik şifreyi <code>SMTP_PASSWORD</code> olarak kullanın</li>
                                            </ul>
                                        </div>
                                        
                                        <div class="col-md-6">
                                            <h6 class="text-primary">3. Config Dosyası</h6>
                                            <pre class="bg-dark text-light p-2 rounded small"><code>define('SMTP_HOST', 'smtp.gmail.com');
define('SMTP_PORT', 587);
define('SMTP_USERNAME', 'sizin@gmail.com');
define('SMTP_PASSWORD', 'app_password');</code></pre>
                                            
                                            <h6 class="text-primary mt-3">4. Test Et</h6>
                                            <p class="small mb-0">
                                                Yukarıdaki formu kullanarak e-posta gönderimini test edin.
                                                Detaylı rehber için <code>EMAIL_KURULUM.md</code> dosyasını inceleyin.
                                            </p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
// Form validation
(function() {
    'use strict';
    window.addEventListener('load', function() {
        var forms = document.getElementsByClassName('needs-validation');
        var validation = Array.prototype.filter.call(forms, function(form) {
            form.addEventListener('submit', function(event) {
                if (form.checkValidity() === false) {
                    event.preventDefault();
                    event.stopPropagation();
                }
                form.classList.add('was-validated');
            }, false);
        });
    }, false);
})();
</script>

<?php include 'includes/footer.php'; ?>