<?php
session_start();
require_once '../config/config.php';
require_once '../includes/functions.php';

$pageTitle = 'Ayarlar';
$currentPage = 'settings';

if (!isLoggedIn() || !isAdmin()) {
    redirect('login.php');
}

// Ayarları kaydet
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        $pdo->beginTransaction();
        
        foreach ($_POST as $key => $value) {
            if ($key !== 'csrf_token') {
                $stmt = $pdo->prepare("
                    INSERT INTO settings (setting_key, setting_value) 
                    VALUES (?, ?) 
                    ON DUPLICATE KEY UPDATE setting_value = VALUES(setting_value)
                ");
                $stmt->execute([$key, $value]);
            }
        }
        
        $pdo->commit();
        addFlashMessage('success', 'Ayarlar başarıyla kaydedildi!');
        redirect('settings.php');
        
    } catch (Exception $e) {
        $pdo->rollBack();
        error_log("Settings save error: " . $e->getMessage());
        addFlashMessage('error', 'Ayarlar kaydedilirken hata oluştu: ' . $e->getMessage());
    }
}

// Mevcut ayarları al
try {
    $stmt = $pdo->query("SELECT setting_key, setting_value FROM settings");
    $settings_raw = $stmt->fetchAll(PDO::FETCH_KEY_PAIR);
    
    // Varsayılan ayarlar
    $default_settings = [
        'site_name' => 'Araç Bakım Servisi',
        'site_description' => 'Profesyonel araç bakım ve onarım hizmetleri',
        'contact_phone' => '+90 532 123 45 67',
        'contact_email' => 'info@aracbakim.com',
        'contact_address' => 'İstanbul, Türkiye',
        'working_hours' => '09:00 - 18:00',
        'quote_expiry_hours' => '48',
        'tax_rate' => '18',
        'currency' => 'TRY',
        'email_notifications' => '1',
        'sms_notifications' => '0',
        'maintenance_mode' => '0',
        'max_file_size' => '5',
        'allowed_file_types' => 'jpg,jpeg,png,pdf,doc,docx',
        'backup_frequency' => 'daily',
        'session_timeout' => '3600',
        'password_min_length' => '6',
        'enable_registration' => '0',
        'google_analytics_id' => '',
        'facebook_pixel_id' => '',
        'smtp_host' => 'smtp.gmail.com',
        'smtp_port' => '587',
        'smtp_username' => '',
        'smtp_password' => '',
        'smtp_encryption' => 'tls',
        'payment_gateway' => 'iyzico',
        'iyzico_api_key' => '',
        'iyzico_secret_key' => '',
        'paytr_merchant_id' => '',
        'paytr_merchant_key' => '',
        'paytr_merchant_salt' => ''
    ];
    
    $settings = array_merge($default_settings, $settings_raw);
    
} catch (Exception $e) {
    error_log("Settings load error: " . $e->getMessage());
    $settings = $default_settings;
}
?>
<?php require_once 'includes/header.php'; ?>

<section class="section">
    <div class="row">
        <div class="col-lg-12">
            <div class="nice-card">
                <div class="card-body">
                    <h5 class="card-title">Sistem Ayarları</h5>
                    
                    <form method="POST" class="needs-validation" novalidate>
                        <input type="hidden" name="csrf_token" value="<?= generateCSRFToken() ?>">
                        
                        <!-- Genel Ayarlar -->
                        <div class="row mb-4">
                            <div class="col-12">
                                <h6 class="text-primary border-bottom pb-2 mb-3">
                                    <i class="fas fa-cog me-2"></i>Genel Ayarlar
                                </h6>
                            </div>
                            
                            <div class="col-md-6 mb-3">
                                <label for="site_name" class="form-label">Site Adı</label>
                                <input type="text" class="nice-form-control" id="site_name" name="site_name" 
                                       value="<?= h($settings['site_name']) ?>" required>
                            </div>
                            
                            <div class="col-md-6 mb-3">
                                <label for="site_description" class="form-label">Site Açıklaması</label>
                                <input type="text" class="nice-form-control" id="site_description" name="site_description" 
                                       value="<?= h($settings['site_description']) ?>">
                            </div>
                            
                            <div class="col-md-4 mb-3">
                                <label for="contact_phone" class="form-label">İletişim Telefonu</label>
                                <input type="text" class="nice-form-control" id="contact_phone" name="contact_phone" 
                                       value="<?= h($settings['contact_phone']) ?>">
                            </div>
                            
                            <div class="col-md-4 mb-3">
                                <label for="contact_email" class="form-label">İletişim E-posta</label>
                                <input type="email" class="nice-form-control" id="contact_email" name="contact_email" 
                                       value="<?= h($settings['contact_email']) ?>">
                            </div>
                            
                            <div class="col-md-4 mb-3">
                                <label for="working_hours" class="form-label">Çalışma Saatleri</label>
                                <input type="text" class="nice-form-control" id="working_hours" name="working_hours" 
                                       value="<?= h($settings['working_hours']) ?>">
                            </div>
                            
                            <div class="col-12 mb-3">
                                <label for="contact_address" class="form-label">Adres</label>
                                <textarea class="nice-form-control" id="contact_address" name="contact_address" rows="2"><?= h($settings['contact_address']) ?></textarea>
                            </div>
                        </div>
                        
                        <!-- İş Ayarları -->
                        <div class="row mb-4">
                            <div class="col-12">
                                <h6 class="text-primary border-bottom pb-2 mb-3">
                                    <i class="fas fa-briefcase me-2"></i>İş Ayarları
                                </h6>
                            </div>
                            
                            <div class="col-md-3 mb-3">
                                <label for="quote_expiry_hours" class="form-label">Teklif Geçerlilik (Saat)</label>
                                <input type="number" class="nice-form-control" id="quote_expiry_hours" name="quote_expiry_hours" 
                                       value="<?= h($settings['quote_expiry_hours']) ?>" min="1" max="720">
                            </div>
                            
                            <div class="col-md-3 mb-3">
                                <label for="tax_rate" class="form-label">KDV Oranı (%)</label>
                                <input type="number" class="nice-form-control" id="tax_rate" name="tax_rate" 
                                       value="<?= h($settings['tax_rate']) ?>" min="0" max="100" step="0.01">
                            </div>
                            
                            <div class="col-md-3 mb-3">
                                <label for="currency" class="form-label">Para Birimi</label>
                                <select class="nice-form-control" id="currency" name="currency">
                                    <option value="TRY" <?= $settings['currency'] === 'TRY' ? 'selected' : '' ?>>Türk Lirası (₺)</option>
                                    <option value="USD" <?= $settings['currency'] === 'USD' ? 'selected' : '' ?>>Dolar ($)</option>
                                    <option value="EUR" <?= $settings['currency'] === 'EUR' ? 'selected' : '' ?>>Euro (€)</option>
                                </select>
                            </div>
                            
                            <div class="col-md-3 mb-3">
                                <label for="session_timeout" class="form-label">Oturum Süresi (Saniye)</label>
                                <input type="number" class="nice-form-control" id="session_timeout" name="session_timeout" 
                                       value="<?= h($settings['session_timeout']) ?>" min="300" max="86400">
                            </div>
                        </div>
                        
                        <!-- Bildirim Ayarları -->
                        <div class="row mb-4">
                            <div class="col-12">
                                <h6 class="text-primary border-bottom pb-2 mb-3">
                                    <i class="fas fa-bell me-2"></i>Bildirim Ayarları
                                </h6>
                            </div>
                            
                            <div class="col-md-6 mb-3">
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" id="email_notifications" name="email_notifications" 
                                           value="1" <?= $settings['email_notifications'] ? 'checked' : '' ?>>
                                    <label class="form-check-label" for="email_notifications">
                                        E-posta Bildirimleri
                                    </label>
                                </div>
                            </div>
                            
                            <div class="col-md-6 mb-3">
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" id="sms_notifications" name="sms_notifications" 
                                           value="1" <?= $settings['sms_notifications'] ? 'checked' : '' ?>>
                                    <label class="form-check-label" for="sms_notifications">
                                        SMS Bildirimleri
                                    </label>
                                </div>
                            </div>
                        </div>
                        
                        <!-- E-posta Ayarları -->
                        <div class="row mb-4">
                            <div class="col-12">
                                <h6 class="text-primary border-bottom pb-2 mb-3">
                                    <i class="fas fa-envelope me-2"></i>E-posta Ayarları
                                </h6>
                            </div>
                            
                            <div class="col-md-3 mb-3">
                                <label for="smtp_host" class="form-label">SMTP Sunucu</label>
                                <input type="text" class="nice-form-control" id="smtp_host" name="smtp_host" 
                                       value="<?= h($settings['smtp_host']) ?>">
                            </div>
                            
                            <div class="col-md-3 mb-3">
                                <label for="smtp_port" class="form-label">SMTP Port</label>
                                <input type="number" class="nice-form-control" id="smtp_port" name="smtp_port" 
                                       value="<?= h($settings['smtp_port']) ?>">
                            </div>
                            
                            <div class="col-md-3 mb-3">
                                <label for="smtp_username" class="form-label">SMTP Kullanıcı Adı</label>
                                <input type="text" class="nice-form-control" id="smtp_username" name="smtp_username" 
                                       value="<?= h($settings['smtp_username']) ?>">
                            </div>
                            
                            <div class="col-md-3 mb-3">
                                <label for="smtp_encryption" class="form-label">Şifreleme</label>
                                <select class="nice-form-control" id="smtp_encryption" name="smtp_encryption">
                                    <option value="tls" <?= $settings['smtp_encryption'] === 'tls' ? 'selected' : '' ?>>TLS</option>
                                    <option value="ssl" <?= $settings['smtp_encryption'] === 'ssl' ? 'selected' : '' ?>>SSL</option>
                                    <option value="" <?= $settings['smtp_encryption'] === '' ? 'selected' : '' ?>>Yok</option>
                                </select>
                            </div>
                            
                            <div class="col-md-6 mb-3">
                                <label for="smtp_password" class="form-label">SMTP Şifre</label>
                                <input type="password" class="nice-form-control" id="smtp_password" name="smtp_password" 
                                       value="<?= h($settings['smtp_password']) ?>" placeholder="Değiştirmek için yeni şifre girin">
                            </div>
                        </div>
                        
                        <!-- Ödeme Ayarları -->
                        <div class="row mb-4">
                            <div class="col-12">
                                <h6 class="text-primary border-bottom pb-2 mb-3">
                                    <i class="fas fa-credit-card me-2"></i>Ödeme Ayarları
                                </h6>
                            </div>
                            
                            <div class="col-md-4 mb-3">
                                <label for="payment_gateway" class="form-label">Ödeme Sağlayıcı</label>
                                <select class="nice-form-control" id="payment_gateway" name="payment_gateway">
                                    <option value="iyzico" <?= $settings['payment_gateway'] === 'iyzico' ? 'selected' : '' ?>>Iyzico</option>
                                    <option value="paytr" <?= $settings['payment_gateway'] === 'paytr' ? 'selected' : '' ?>>PayTR</option>
                                    <option value="stripe" <?= $settings['payment_gateway'] === 'stripe' ? 'selected' : '' ?>>Stripe</option>
                                </select>
                            </div>
                            
                            <div class="col-md-4 mb-3">
                                <label for="iyzico_api_key" class="form-label">Iyzico API Key</label>
                                <input type="text" class="nice-form-control" id="iyzico_api_key" name="iyzico_api_key" 
                                       value="<?= h($settings['iyzico_api_key']) ?>">
                            </div>
                            
                            <div class="col-md-4 mb-3">
                                <label for="iyzico_secret_key" class="form-label">Iyzico Secret Key</label>
                                <input type="password" class="nice-form-control" id="iyzico_secret_key" name="iyzico_secret_key" 
                                       value="<?= h($settings['iyzico_secret_key']) ?>">
                            </div>
                        </div>
                        
                        <!-- Sistem Ayarları -->
                        <div class="row mb-4">
                            <div class="col-12">
                                <h6 class="text-primary border-bottom pb-2 mb-3">
                                    <i class="fas fa-server me-2"></i>Sistem Ayarları
                                </h6>
                            </div>
                            
                            <div class="col-md-4 mb-3">
                                <label for="max_file_size" class="form-label">Maksimum Dosya Boyutu (MB)</label>
                                <input type="number" class="nice-form-control" id="max_file_size" name="max_file_size" 
                                       value="<?= h($settings['max_file_size']) ?>" min="1" max="100">
                            </div>
                            
                            <div class="col-md-4 mb-3">
                                <label for="backup_frequency" class="form-label">Yedekleme Sıklığı</label>
                                <select class="nice-form-control" id="backup_frequency" name="backup_frequency">
                                    <option value="daily" <?= $settings['backup_frequency'] === 'daily' ? 'selected' : '' ?>>Günlük</option>
                                    <option value="weekly" <?= $settings['backup_frequency'] === 'weekly' ? 'selected' : '' ?>>Haftalık</option>
                                    <option value="monthly" <?= $settings['backup_frequency'] === 'monthly' ? 'selected' : '' ?>>Aylık</option>
                                </select>
                            </div>
                            
                            <div class="col-md-4 mb-3">
                                <label for="password_min_length" class="form-label">Minimum Şifre Uzunluğu</label>
                                <input type="number" class="nice-form-control" id="password_min_length" name="password_min_length" 
                                       value="<?= h($settings['password_min_length']) ?>" min="4" max="20">
                            </div>
                            
                            <div class="col-12 mb-3">
                                <label for="allowed_file_types" class="form-label">İzin Verilen Dosya Türleri</label>
                                <input type="text" class="nice-form-control" id="allowed_file_types" name="allowed_file_types" 
                                       value="<?= h($settings['allowed_file_types']) ?>" 
                                       placeholder="jpg,jpeg,png,pdf,doc,docx">
                                <div class="form-text">Virgülle ayırarak yazın (örn: jpg,png,pdf)</div>
                            </div>
                            
                            <div class="col-md-6 mb-3">
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" id="maintenance_mode" name="maintenance_mode" 
                                           value="1" <?= $settings['maintenance_mode'] ? 'checked' : '' ?>>
                                    <label class="form-check-label" for="maintenance_mode">
                                        Bakım Modu
                                    </label>
                                </div>
                            </div>
                            
                            <div class="col-md-6 mb-3">
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" id="enable_registration" name="enable_registration" 
                                           value="1" <?= $settings['enable_registration'] ? 'checked' : '' ?>>
                                    <label class="form-check-label" for="enable_registration">
                                        Kullanıcı Kaydına İzin Ver
                                    </label>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Analitik Ayarları -->
                        <div class="row mb-4">
                            <div class="col-12">
                                <h6 class="text-primary border-bottom pb-2 mb-3">
                                    <i class="fas fa-chart-line me-2"></i>Analitik Ayarları
                                </h6>
                            </div>
                            
                            <div class="col-md-6 mb-3">
                                <label for="google_analytics_id" class="form-label">Google Analytics ID</label>
                                <input type="text" class="nice-form-control" id="google_analytics_id" name="google_analytics_id" 
                                       value="<?= h($settings['google_analytics_id']) ?>" placeholder="G-XXXXXXXXXX">
                            </div>
                            
                            <div class="col-md-6 mb-3">
                                <label for="facebook_pixel_id" class="form-label">Facebook Pixel ID</label>
                                <input type="text" class="nice-form-control" id="facebook_pixel_id" name="facebook_pixel_id" 
                                       value="<?= h($settings['facebook_pixel_id']) ?>" placeholder="123456789012345">
                            </div>
                        </div>
                        
                        <div class="text-end">
                            <button type="submit" class="nice-btn nice-btn-primary">
                                <i class="fas fa-save me-2"></i>Ayarları Kaydet
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</section>

<script>
// Form validation
(function() {
    'use strict';
    window.addEventListener('load', function() {
        var forms = document.getElementsByClassName('needs-validation');
        var validation = Array.prototype.filter.call(forms, function(form) {
            form.addEventListener('submit', function(event) {
                if (form.checkValidity() === false) {
                    event.preventDefault();
                    event.stopPropagation();
                }
                form.classList.add('was-validated');
            }, false);
        });
    }, false);
})();

// Test email settings
function testEmailSettings() {
    const formData = new FormData();
    formData.append('action', 'test_email');
    formData.append('smtp_host', document.getElementById('smtp_host').value);
    formData.append('smtp_port', document.getElementById('smtp_port').value);
    formData.append('smtp_username', document.getElementById('smtp_username').value);
    formData.append('smtp_password', document.getElementById('smtp_password').value);
    formData.append('smtp_encryption', document.getElementById('smtp_encryption').value);
    
    fetch('test_email.php', {
        method: 'POST',
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            alert('E-posta ayarları başarıyla test edildi!');
        } else {
            alert('E-posta testi başarısız: ' + data.message);
        }
    })
    .catch(error => {
        console.error('Error:', error);
        alert('Test sırasında hata oluştu.');
    });
}
</script>

<?php require_once 'includes/footer.php'; ?>