<?php
// Aktif sayfa kontrolü için
$current_page = basename($_SERVER['PHP_SELF']);
?>
<nav class="col-md-3 col-lg-2 d-md-block sidebar collapse">
    <div class="position-sticky pt-3">
        <div class="text-center mb-4">
            <i class="fas fa-car text-primary fa-2x"></i>
            <h6 class="text-white mt-2">Araç Bakım</h6>
        </div>
        
        <ul class="nav flex-column">
            <li class="nav-item">
                <a class="nav-link <?= $current_page === 'dashboard.php' ? 'active' : '' ?>" href="dashboard.php">
                    <i class="fas fa-tachometer-alt"></i> Dashboard
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link <?= in_array($current_page, ['quotes.php', 'quote_detail.php', 'create_quote.php']) ? 'active' : '' ?>" href="quotes.php">
                    <i class="fas fa-clipboard-list"></i> Teklif Başvuruları
                    <?php
                    // Bekleyen başvuru sayısını al
                    try {
                        $stmt = $pdo->prepare("SELECT COUNT(*) as count FROM quote_requests WHERE status = 'NEW'");
                        $stmt->execute();
                        $pending_count = $stmt->fetch()['count'];
                        if ($pending_count > 0): ?>
                            <span class="badge bg-danger ms-2"><?= $pending_count ?></span>
                        <?php endif;
                    } catch (Exception $e) {
                        // Hata durumunda sessizce devam et
                    }
                    ?>
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link <?= in_array($current_page, ['orders.php', 'order_detail.php']) ? 'active' : '' ?>" href="orders.php">
                    <i class="fas fa-shopping-cart"></i> Siparişler
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link <?= in_array($current_page, ['customers.php', 'customer_detail.php']) ? 'active' : '' ?>" href="customers.php">
                    <i class="fas fa-users"></i> Müşteriler
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link <?= in_array($current_page, ['products.php', 'product_add.php', 'product_edit.php', 'categories.php']) ? 'active' : '' ?>" href="products.php">
                    <i class="fas fa-box"></i> Ürün/Hizmetler
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link <?= $current_page === 'reports.php' ? 'active' : '' ?>" href="reports.php">
                    <i class="fas fa-chart-bar"></i> Raporlar
                </a>
            </li>
            <?php if (isAdmin()): ?>
            <li class="nav-item">
                <a class="nav-link <?= $current_page === 'settings.php' ? 'active' : '' ?>" href="settings.php">
                    <i class="fas fa-cog"></i> Ayarlar
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link <?= in_array($current_page, ['users.php', 'user_add.php', 'user_edit.php']) ? 'active' : '' ?>" href="users.php">
                    <i class="fas fa-user-cog"></i> Kullanıcılar
                </a>
            </li>
            <?php endif; ?>
        </ul>
        
        <hr class="my-3">
        
        <div class="dropdown">
            <a href="#" class="nav-link dropdown-toggle text-white" data-bs-toggle="dropdown">
                <i class="fas fa-user"></i> <?= h($_SESSION['user_name']) ?>
            </a>
            <ul class="dropdown-menu">
                <li><a class="dropdown-item" href="profile.php"><i class="fas fa-user-edit"></i> Profil</a></li>
                <li><hr class="dropdown-divider"></li>
                <li><a class="dropdown-item" href="logout.php"><i class="fas fa-sign-out-alt"></i> Çıkış</a></li>
            </ul>
        </div>
    </div>
</nav>
