<?php
session_start();
require_once '../config/config.php';
require_once '../includes/functions.php';

header('Content-Type: application/json');

if (!isLoggedIn()) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'Oturum geçersiz.']);
    exit;
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Geçersiz istek metodu.']);
    exit;
}

try {
    $input = json_decode(file_get_contents('php://input'), true);
    
    if (!isset($input['customer_id'])) {
        throw new Exception('Müşteri ID belirtilmedi.');
    }
    
    $customerId = intval($input['customer_id']);
    
    if (!$customerId) {
        throw new Exception('Geçersiz müşteri ID.');
    }
    
    // Müşterinin araçlarını getir
    $stmt = $pdo->prepare("
        SELECT id, brand, model, year, plate, chassis_number
        FROM vehicles 
        WHERE customer_id = ? 
        ORDER BY brand, model, year
    ");
    $stmt->execute([$customerId]);
    $vehicles = $stmt->fetchAll();
    
    echo json_encode([
        'success' => true,
        'vehicles' => $vehicles,
        'count' => count($vehicles)
    ]);
    
} catch (Exception $e) {
    error_log("Get customer vehicles error: " . $e->getMessage());
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}
?>
